---
title: Introduction à l'étude de l'instrumentation pour l'astronomie
published: true
routable: true
visible: false
lessons:
    - slug: instrumentation-representations-of-univers-4
      name: LINÈAIRE : Instrumentation et représentations de l'Univers
      order: 1
---


### Instrumentation et représentations de l'Univers : <br>une approche historique

#### 1 - Le rôle de l'observation dans l'astronomie
<br>
Qui pourrait prétendre aujourd'hui que les représentations de l'univers que les femmes et les hommes
se font ne dépendent pas de l'instrumentation astronomique ? Comment ces 
images somptueuses de nébuleuses, de matière interstellaire ou de galaxies seraient-elles
entrées dans nos représentations du ciel sans les grands télescopes au sol ou dans l'espace,
équipés de récepteurs sophistiqués?  N'en a-t-il pas toujours été ainsi ? Poser la 
question est déjà y répondre. 

Pourtant le rôle joué par l'observation dans l'acquisition des connaissances astronomiques 
est objet de débat. Cette question est à rapprocher du problème gnoséologique traditionnel
sur la fonction des sens dans l'acquisition des connaissances humaines. 
<!--!!!!! *Terminologie : gnoséologie*
!!!!! À faire-->
Déclinée sous de multiples formes, cette question est évoquée plaisamment par Jean DE LA FONTAINE
dans sa fable "un animal dans la lune". 

> "Pendant qu'un philosophe assure<br>
> Que toujours par leur sens les hommes sont dupés,<br>
> Un autre philosophe jure<br>
> Qu'ils ne nous ont jamais trompés.<br>
> Tous les deux ont raison ; ... "

et de poursuivre 

> "La raison décide en maîtresse.<br>
> Mes yeux, moyennant ce secours,<br>
> Ne me trompent jamais en me mentant toujours."
<!--
!! *Pour aller plus loin : Jean de la Fontaine*
!! A faire
-->

Cette approche dialectique de Jean de LA FONTAINE exprime une idée implicitement 
admise dans leur pratique par les astronomes modernes. C'est désormais un truisme 
que d'évoquer une action correctrice de la "raison", c'est à dire de présupposés 
théoriques pour "interpréter" une observation. C'est aussi une banalité que d'admettre 
que la mise en oeuvre des "sens", autrement dits "des observations", est une phase 
indispensable dans le processus d'acquisition des connaissances en astronomie. 
Ces choses n'ont pas toujours paru aussi claires.  Et aujourd'hui encore elles 
sont enjeu de débat philosophique ; même si les présupposés en la matière, largement
acceptés dans la pratique et souvent inconsciemment par la grande majorité de la communauté 
astronomique, constituent dans les faits le dépassement de la contradiction préconisée 
par Jean de la Fontaine !   

Cette situation est l'héritage d'une longue histoire de l'astronomie au cours de 
laquelle deux principaux courants d'idées se sont affrontés. Cet affrontement pris 
corps et se formalisa dès l'Antiquité grecque entre le IV<sup>ème</sup> et le VI<sup>ème</sup> 
siècle avant notre ère. Il a subsisté depuis en traversant toute l'histoire du monde occidental. 
L'un des courants établit que la perfection abstraite comme principe, premier 
ayant une nature divine. PLATON, illustre porte drapeau de se courant philosophique, précise par exemple :

> " ... le dieu, ayant décidé de former le Monde, le plus possible à la ressemblance 
du plus beau des êtres intelligibles et d'un Être parfait en tout, en a fait un Vivant unique ...".

Connaître le monde se réduit ainsi à rechercher la perfection abstraite, notamment
des nombres et des formes ; la démarche sera ainsi d'ordre théorique et/ou spéculatif
sans qu'à aucun moment n'apparaisse l'opportunité d'une confrontation à un autre type 
de réalité concrète (qui d'ailleurs n'existe pas vraiment dans cette conception du monde). 
Dans ce courant d'idées, l'instrumentation n'a pas sa place ; elle est inutile. 

L'autre courant d'idée peut être illustré par les propos de LUCRECE ou ceux énoncés 
un peu plus de deux siècles plus tôt par ÉPICURE. 

> "Le principe qui sera notre point de départ, c'est que rien, jamais, n'est engendré
de rien par l'effet d'un pouvoir divin".
 (LUCRECE, page 133 du livre de Marcel CONCHE,  édition de Mégare, 1990)

> "Rien ne vient du non-être ... l'univers a toujours été et sera toujours..." (EPICURE)

> "En quoi donc devraient-on avoir la plus grande foi que dans les sens ? S'il nous trompent, 
la raison pourra t'elle déposer contre eux, elle qui en est issue tout entière ?" (LUCRECE)

> "En étudiant la nature, il ne faut pas se conformer à des principes sans fondement 
et à des lois abstraites, mais être attentif à ce que suggèrent les phénomènes" 
(EPICURE, Lettre à Pythoclés sur les Météores)

Ce courant d'idées pose donc comme principe premier que l'univers existe indépendamment 
de la conscience que l'on peut en avoir. Pour le connaître, nous allons raisonner à partir 
des informations recueillies par "nos sens"("nos observations"). Il est clair que, 
dans ce courant d'idées, l'observation ou la mesure occupe une place centrale. 
Au point de faire dire  à KANT  dans sa "critique de la raison pure" : EPICURE ne
dépasse jamais, dans ces raisonnements, les limites de l'expérience. 

Mais reconnaissont à KANT l'honnêteté du doute, car il place une note correctrice dans sa déclaration :

> "Tel est l'opposition entre l'Épicurisme et le Platonisme. Chacun d'eux dit plus 
qu'il ne sait. Le premier encourage et fait avancer le savoir, mais au préjudice de 
l'intérêt pratique ; le second fournit à l'intérêt pratique mais [...]  tout ce dont
nous ne pouvons avoir qu'un savoir spéculatif, il permet à la raison de s'attacher 
à des explications idéalistes des phénomènes naturels et de négliger par rapport à 
eux l'investigation physique."

Sa note a été éclairante :

> "C'est, cependant, encore une question que celle de savoir si EPICURE a jamais
avancé ces principes en qualité d'affirmation objective. Si [...] il aurait montré 
en cela un esprit plus véritablement philosophique qu'aucun des sages de l'Antiquité, 
que dans l'explication des phénomènes, il faille procéder comme si le champ de la 
recherche n'était borné par aucune limite ni par aucun commencement du monde, qu'il
faille admettre la matière du monde comme elle doit l'être, si nous voulons en être 
instruit par l'expérience, que l'on ne doit rechercher d'autre origine des événements
que celle qui est déterminée par les lois immuables de la nature, et qu'enfin l'on ne
doive recourir à aucune cause distincte du monde, ce sont là, encore à présent, des
principes très justes, mais très peu observés, qui permettent d'étendre la philosophie 
spéculative..." (KANT,  Critique de la raison pure).

Ainsi se dessinent les conditions d'une démarche féconde qui permet de dépasser la 
contradiction entre l'acceptation de l'observation comme moment fondamental de la 
connaissance et la nécessité d'une représentation abstraite du phénomène étudié.

GALILEE illustre dans sa pratique le dépassement concret de cette contradiction, 
ouvrant par là l'ère de l'astronomie moderne en adoptant une démarche "scientifique".
À l'idée que le monde "est écrit en langage mathématique", GALILEE ajoute une activité
de développement instrumental. Il associe dans sa pratique de recherche,
1. l'usage concret d'une nouvelle instrumentation
2. l'approfondissement d'une pensée abstraite destinée à dépasser les apparences pour 
accéder aux lois essentielles des phénomènes réels.

Ce faisant, GALILEE intègre le courant de pensée, déjà formulé, confusément, par 
PYTHAGORE (qui place le nombre au noeud des descriptions de l'univers) avec l'autre 
courant, le matérialisme épicurien qui suppose l'existence de l'Univers indépendant
de notre conscience et place l'usage de nos sens (donc l'observation et/ou la mesure
et/ou l'expérimentation) sur le chemin de notre connaissance de l'univers. Ainsi,
contrairement à l'idéalisme philosophique de filiation platonicienne qui borne le 
champ de la connaissance à la spéculation abstraite, le matérialisme épicurien devient
fécond dès lors qu'il intègre et dépasse l'horizon de la simple observation (ou de la 
perception des sens) en accédant aux besoins de décrire la réalité par une théorie, 
si possible écrite "en langage mathématiques". C'est cette confrontation théorie/mesure 
qui fondent la démarche scientifique, notamment en astronomie. 

Une théorie, une description abstraite d'un phénomène ou d'un objet, ne deviennent 
"scientifiques" que si elles sont susceptibles d'induire une prévision (si possible quantitative) 
qui pourra ultérieurement être confronté à la réalité par l'observation/mesure/expérience.   
Cette confrontation sera un moment essentiel de la validation de la théorie ou de la 
description abstraite, moment essentiel mais pas élément exclusif de validation.
La validation d'une théorie passe toujours par diverses étapes dont l'ultime, le débat 
épistémologique (pluraliste) ne peut et ne doit pas être exclu. 

Ainsi, nous rencontrerons, tout au long de l'histoire de l'astronomie, l'affrontement 
entre ces deux grands courants. C'est cette polarisation qui crée le cadre des relations
établies tout au long de l'histoire entre le développement de l'instrumentation astronomique
et les représentations de l'univers. L'histoire de l'astronomie à l'histoire des relations 
multiples tissées entre les représentations de l'Univers et les mesures (ou observations)
accomplies grâce à une instrumentation en évolution. À un instant donné l'existence 
et la disponibilité d'une instrumentation ont toujours résulté de causes multiples : 
volonté des astronomes certes mais aussi des possibilités technologiques et surtout, 
de la capacité de disposer des ressources économiques nécessaires (avec tout ce que 
cela implique dans l'organisation sociale,  économique, politique et culturelle de la société). 
L'histoire de l'astronomie et de son instrumentation est éclairante à ce sujet. 
Elle permet de mettre en relation d'une part l'instrumentation et les représentations 
de l'univers, et d'autre part les activités de recherche (au sein desquels se développent 
l'instrumentation) et la société. 

<br>

#### 2 - L'astronomie et les préhistoires
<br>
Quand commence l'astronomie ? Sans doute il y a bien longtemps lorsque la pensée 
abstraite est devenue accessible aux femmes et aux hommes de la préhistoire. 
Encore qu'il faille se méfier des mots. L'astronomie de ses époques reculées n'avait 
de commun avec la nôtre que l'objectif de connaissance de l'univers ; cet univers 
pouvant souvent se réduire au ciel avec les phénomènes qui s'y déroulent. De plus, 
le mot "préhistoire" s'applique à des époques et des sociétés humaines qui ne possèdent
pas l'écriture. Autant dire que la préhistoire ne peut pas se réduire à un intervalle 
de temps dans une chronologie universelle de l'évolution humaine.   

Il n'y a pas une préhistoire, mais de nombreuses préhistoires dans certaines s'achève 
de nos jours. L'étude des sociétés préhistoriques quasi contemporaines montre toute la
richesse culturelle que de telles sociétés peuvent avoir. Malheureusement, l'absence 
d'écriture établit un certain type de limitation absolue dans l'acquisition et la 
perpétuation des connaissances. En particulier, le savoir va évoluer sans cesse en 
perdant la connaissance des états antérieurs. Aussi est-il très difficile, souvent 
impossible, de percevoir par exemple, quelles étaient les connaissances astronomiques
des sociétés préhistoriques de l'Europe occidentale. Certains chercheurs voient dans 
des monuments mégalithiques, comme celui de Stonehenge en Grande-Bretagne, des observatoires 
enregistrant les directions caractéristiques des solstices et des équinoxes. Si tel 
était le cas, le gigantisme dans l'instrumentation astronomique ne date pas d'aujourd'hui!
Mais il est bien difficile de conclure sur ce sujet, à cause de la pauvreté des informations
disponibles à ce jour.

Sans doute aussi, existait-il dans l'Amérique précolombienne des "observatoires" 
astronomique de pierre (Le Caracol de Chichen Itza au Yucatan ?)  permettant la mesure
d'angles formés par différentes directions des astres "visibles", dont les plus importants
étaient, d'évidence, le soleil et la lune. Il s'en est fallu de peu pour que nous 
puissions beaucoup mieux connaître cette "astronomie" et ses instruments puisque 
le peuple aztèque, par exemple, possédait une langue et un ensemble de signes constituant
une forme très archaïque d'écriture.  
Les Mayas avaient eux aussi, dès le V<sup>ème</sup> siècle, deux types d'écriture primitive.
Malheureusement les conquérants européens, dans leur volonté d'imposer le dogme chrétien, 
détruisirent la plupart des manuscrits mayas et aztèques dont beaucoup avaient, pour support,
des écorces d'arbres. Il ne reste aujourd'hui que des monuments de pierre dont une des fonctions
semble bien avoir été celle d'observatoires astronomiques ; des recherches sont en 
cours sur ce sujet. D'autres vestiges existent comme, par exemple, un objet en mosaïque, 
calendrier aztèque attestant une connaissance du temps corrélé au mouvement des astres.
Indépendamment de l'écriture, des gravures sur roche témoignent de l'intérêt que les 
êtres humains ont souvent porté au phénomène du ciel. Des symboles figurants la lune, 
le soleil et les étoiles ont été gravés sur de nombreux rochers depuis les Pyrénées 
jusqu'en Amérique du Nord. Mais l'interprétation de tous ces pictogrammes demeure 
problématique. Il faut attendre l'écriture pour accéder à un ensemble suffisant 
d'informations pour caractériser une "astronomie".
Ce n'est probablement pas un hasard si les trois foyers indépendants d'apparition 
de l'écriture coïncident parfaitement avec les trois sites où s'est accomplie,
quelques millénaires plutôt et de manière probablement indépendantes, la révolution
néolithique. 

Voici environ une dizaine de milliers d'années, des peuples se sédentarisent en Mésopotamie,
en tirant principalement leurs ressources d'une agriculture naissante. Cette révolution 
constitue le passage des sociétés préhistoriques paléolithiques (dont l'économie repose 
entièrement sur l'exploitation directe des ressources naturelles par la chasse, la pêche
et la cueillette) aux sociétés néolithiques déjà proches des civilisations protohistoriques.
<!--
!!!!! *Terminologie : préhistorique, protohistoriques, historique*    
!!!!! À faire.
-->
En moins d'un millénaire, cette révolution économique sociale et culturelle s'étend 
tout autour de la partie orientale du bassin méditerranéen, depuis la Grèce jusqu'à 
l'Egypte. Durant les deux millénaires suivants cette zone s'agrandit vers le Caucase
et les régions de l'actuel Bulgarie alors que, parallèlement et de manière probablement 
indépendante, la révolution néolithique s'opère en Amérique Centrale. Vers 5000 à 6000 ans 
avant notre ère, ce dernier foyer s'est étendu sur une bonne partie du Mexique actuel. 
Dans le même temps, sur notre continent, les civilisations néolitiques habitent 
désormais tout le pourtour de la Méditerranée, sur une frange de terre très étroite 
dans la partie occidentale, alors qu'à l'Est l'expansion atteint la vallée de l'Indus ; 
une autre zone traverse l'Europe de la mer Noire à la mer du Nord. Simultanément, 
et probablement encore une fois de manière indépendante, un troisième foyer de civilisation 
néolithique apparaît dans la plaine de Chine, le long du "fleuve Jaune" (Houang-Ho ou Huanghe,
ou encore Huang Hé). Il faudra encore 3,5 millénaires pour que dans cette vallée fertile
apparaissent l'écriture du chinois ancien. Une riche civilisation évoluera dans cette région,
de manière relativement autonome, pendant de très nombreux siècles. Une astronomie se
développera, avec des instruments et des représentations originales de l'univers. 
Sans doute, beaucoup de travail reste à faire pour comparer le cours de cet astronomie, 
très florissante à certaines époques, avec celle qui s'est développée depuis la Mésopotamie
ancienne jusqu'à l'Europe occidentale de la Renaissance, en passant par la Grèce antique
et l'Égypte. 

Mais revenons en arrière, vers la première moitié du quatrième millénaire avant notre ère.
Probablement dans les basses vallées de l'Euphrate et du Tigre, à proximité du Golfe
Persique les sumériens gravent des signes cunéiformes qui constituent la souche commune
la plus ancienne de la plupart des langues parlées et écrites en usage aujourd'hui
(exception faite de celles dérivant de la souche du chinois ancien). Avec l'apparition 
de l'écriture, des textes sont écrits qui fournissent quantité d'informations sur
cette civilisation.

<br>

#### 3 - L'astronomie et son instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; en Mésopotamie antique
<br>
Les premiers textes qui abordent des questions touchant à l'astronomie sont des environs 
du XVII<sup>ème</sup> siècle avant notre ère. S'il nous renseignent sur l'astronomie 
de l'époque, ils révèlent aussi un fond culturel, probablement hérité de civilisations
préhistoriques. Après la révolution néolithique va exister une représentation de l'univers
proche des apparences perceptibles par nos sens, en même temps que se développe une pensée
abstraite déjà très élaborée. Avec l'opiniâtre volonté de se libérer d'une soumission
aux forces aux occultes de la nature, la pensée humaine amorce dans la Mésopotamie 
ancienne un cheminement qui la conduira quelques siècles plus tard au rationalisme 
grec de l'Antiquité. Dans le même temps, le maintien de conceptions et de pratiques 
religieuses constitue le fond culturel à l'origine <!--de la Bible et--> des religions
monothéistes. Ainsi, la culture mésopotamienne est-elle à l'origine d'une double 
filiation contradictoire. Cette dualité se retrouve dans l'enchevêtrement de l'astronomie 
et de l'astrologie dans la Mésopotamie dans la Mésopotamie antique, qui se développe dans
la période allant de l'avènement de l'écriture (vers 3200 &plusmn; 200 ans) à la 
suprématie de la Grèce antique vers 600 &plusmn; 100 ans avant notre ère. 

La représentation de l'univers consiste en une boule creuse ayant deux hémisphères 
distinctes :  l'En haut correspondant au ciel, et l'En bas, déjà identifié à l'enfer.   
Les deux hémisphères sont séparés par une couche liquide, la mer au centre de laquelle
surnage la terre. La nature de la terre est distincte de celle des autres régions de
l'univers ; elle est l'habitat des êtres humains. Beaucoup de phénomènes, notamment
terrestres, restent mystérieux ; leurs occurrences ainsi que les forces qui semblent
les animer vont être soumises à l'action de divinités. À l'image des structures de
la société mésopotamienne, les divinités sont fortement hiérarchisées et une subtile
organisation du travail répartit les attributions de chacune. Les divinités demeurent
là où les humains ne sont pas : dans le ciel et dans l'enfer. L'intérêt qu'elles 
portent aux personnes humaines est occasionnel, même si il est clair que face à 
elles le statut de l'humain est conçu davantage comme celui d'un serviteur que d'un
être libre. Inventés et fabriqués par les dieux pour produire par leur travail les 
biens de consommation et d'usage, les êtres humains étaient en quelque sorte les 
employés des divinités. Celle-ci leur adressaient leurs consignes au travers de 
messages écrits corrélés toujours un phénomène occasionnel qui rompait la routine
quotidienne. Ainsi, l'écriture se faisait dans des objets accessibles dans l'environnement 
des êtres humains. Deux catégories d'objets existaient, celle des objets terrestres 
et celles des objets et phénomènes du ciel. De ce fait, le ciel était d'une sorte 
de tableau sur lequel tout changement devenait un message à décrypter, message dont
le contenu était une prescription pour l'avenir des humains. L'idée d'associer la 
lecture du ciel à une divination déterminant l'avenir, constitue probablement l'origine
principale de l'astrologie ; sa source remonte à la Mésopotamie antique. 

De fait, pour identifier le message divin, il convenait de faire la part des configurations
invariantes du ciel et donc sans intérêt, avec les changements porteurs d'information.
Deux types de besoin en résultaient : bien connaître le ciel invariant et assurer
une surveillance continue du ciel. Si le premier pouvait être comblé par des efforts
d'individus solitaires, le second nécessitait des moyens en personnel ! Il est probable 
aussi que, parallèlement à cette "logique de recherche" cohérente avec le système 
d'idées dominantes, la curiosité humaine tendue vers la volonté de mieux connaître 
pour mieux maîtriser son devenir a dû jouer un rôle non négligeable. Toujours est-il
qu'au premier millénaire avant notre ère la séquence zodiacale était identifiée. 
Les sept astres majeurs étaient repérés depuis longtemps : à côté du soleil (Shamash) 
et de la lune (Sîn), les cinq planètes majeures étaient connues : Vénus (Ishtar, 
nom de la déesse de l'amour), Jupiter ("l'astre blanc"), Mercure ("le mouflon"), 
Mars ("l'enflammé", sans doute à cause de sa couleur rouge perceptible à l’œil nu) 
et Saturne ("le constant"). Dès le milieu du second millénaire un "traité" était
publié ; il fut remanié et complété jusqu'au milieu du premier millénaire. Une mission 
des astres est identifiée comme devant définir et régler l'ordre du temps. Ainsi 
apparaît le besoin de connaître, donc de mesurer, le mouvement des astres, c'est-à-dire
l'évolution de la direction dans laquelle on les voit. Est-ce l'origine des premiers 
instruments d'astronomie connus de manière fiable? Toujours est-il qu'apparaît le
gnomon et les polos (voir l'axe "parallèle" de ce cours, partie "Instruments et
systèmes instrumentaux").

<br>

#### 4 - L'astronomie et son instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; dans la Grèce antique et l'Empire romain
<br>
Beaucoup d'auteurs accordent peu de place à la Grèce antique quand il 
s'agit de traiter de l'instrumentation pour l'astronomie. N'est-ce point le résultat 
d'une vision trop superficielle qui réduit l'instrumentation des objets inerte ?
Pourtant, des tables astronomiques mésopotamiennes des second et premier millénaires 
avant notre ère, aux compilations de Ptolémée (vers +150), que de chemin parcouru 
sur le plan des mesures du mouvement des astres, de leur précision et de leur interprétation!
On a aussi beaucoup limité l'astronomie grecque au spéculation de l'époque classique
(de - 500 à moins 300), sans doute à cause de l'éblouissement causé par PLATON et au 
poids du dogme aristotélicien qui pesa de manière hégémonique sur près de deux millénaires. 
Aujourd'hui encore l'influence de ce dogme persiste et il n'est pas rare de le voir surgir
à nouveau dans des pratiques de recherche contemporaines...   

Le monde grec, surtout si on s'intéresse principalement à la dimension culturelle, 
se définit davantage par un ensemble de caractères de civilisation que par une localisation 
géographique. On a coutume de distinguer une époque "archaïque" (de -800 à moins 500), 
une période "classique" (de -500 à -323) et une période "hellénistique" (de -323 
à la fin du premier siècle avant notre ère) avant la fusion définitive dans l'Empire romain.

Mais dès l'époque archaïque, la civilisation grecque ne saurait se limiter à une 
seule région de la péninsule des Balkans. Aux implantations insulaires et sur la côte 
occidentale de l'actuelle Turquie s'ajoutent très vite des colonies et cités-états 
en Italie du Sud, en Sicile, Sardaigne, sur les côtes provençales, catalanes, andalouses 
et africaines.  De fréquences échanges, commerciaux et de peuplement, s'opèrent très vite.
Ces mouvements ne feront que s'accroître, au point de constituer sous Alexandre (vers -330 / -340)
un immense "Empire" s'étendant des colonies de la Méditerranée occidentale à la vallée
de l'Indus, englobant dans cette "Grèce antique", par exemple, la Mésopotamie et l'Égypte.
Ainsi, la Grèce antique peut-elle être vue comme l'étape succédant à la riche civilisation
mésopotamienne, en englobant de très nombreuses contrées même si leur lien politique avec 
la Grèce proprement dite fut parfois ténu ou épisodique. Ainsi, par exemple, l'Égypte vécut
une réelle osmose culturelle avec les cités grecques même si des liens politiques de
fédération ou d'assujettissement n'existèrent seulement qu'à la fin de la période classique (- 332 / -330). 
Après cet épisode s'ensuivit une "indépendance" de l'Égypte sous le règne des Lagides qui apparaît, 
de fait, sur les plans respectivement économique et politique,  comme une réelle colonisation 
de ce pays par une minorité "grecque". L'époque qui commence vers la fin du III<sup>ème</sup> 
siècle avant notre ère fut extrêmement riche sur le plan culturel, très féconde en acquisition
de connaissances nouvelles. Les événements majeurs en astronomie se produisirent désormais
sur le sol égyptien et la capitale culturelle de la "Grèce antique" était devenue Alexandrie.

Le rayonnement de cette cité se perpétua d'ailleurs avec l'annexion de l'Égypte à 
l'Empire romain (-30) pour se prolonger encore pendant une demi-douzaine de siècles 
au moins. Il est vrai qu'en astronomie, l'Empire romain n'apporta pas un réel renouvellement 
des idées ni un élargissement notable des connaissances. Aussi, peut-on inscrire la culture 
astronomique des pays colonisés par Rome puis celle de tout l'Empire romain (à partir du 1er
siècle avant notre ère) dans le prolongement continu de l'astronomie "grecque". Il faut se
garder toutefois d'une vue trop réductrice sur cette période qui couvre plus d'un millénaire 
et qui se réfère à une zone géographique qui va bien au-delà du pourtour du bassin méditerranéen.
Surtout que ces civilisations connurent des époques très fécondes avec la simultanéité 
de représentations de l'univers diversifiées, et quelquefois franchement opposées. 

Dès le V<sup>ème</sup> siècle avant notre ère la pensée grecque, si elle reste fortement
influencée par les modèles de la Mésopotamie ancienne, marque très vite une rupture 
quant à la perception de la place des hommes dans la nature. Ainsi l'observation 
du ciel n'est plus motivée par la nécessité d'identifier le message des divinités,
mais bien plutôt par la volonté de connaître les lois auxquelles obéit le monde. 
Ces évolutions de la pensée humaine ont un ancrage essentiellement collectif. 
La pensée novatrice d'un individu isolé qui n'est pas relayée par une appropriation 
collective d'un groupe humain (pour la traduire ensuite, en actes concrets), reste 
en général sans lendemain ; elle disparaît dans l'oubli provisoire ou définitif. 
Dans le cas heureux ou le succès social d'une pensée individuelle s'affirme, un
autre problème apparaît : celui d'une reconnaissance de paternité ! Combien de
querelles et de polémiques ont entouré l'attribution de paternité pour les découvertes
importantes ! De sorte qu'il est toujours difficile d'affirmer que telle ou telle
personne est la première à avoir eu l'idée originale ou avoir accompli la découverte
marquante. 
La marche d'incertitude ne peut jamais s'annuler ;  elle s'accroît d'autant plus 
que notre regard se porte sur le passé. Au point que pour l'Antiquité, certains 
auteurs mettent même parfois en doute le fait qu'un supposé grand personnage ait 
pu exister. Il en est ainsi, par exemple, pour des auteurs dont l'oeuvre originale
supposée ne nous est pas parvenue. Nous ne la connaissons qu'au travers de citations
plus ou moins reformulées. Pourtant, il est commode de jalonnais l'évolution de
la pensée humaine par des noms célèbres qui marquent notre culture. Au fond, même
s'ils ne sont pas les créateurs originaux, même s'ils n'ont jamais existé, leurs 
noms restent attachés à une étape marquante de la connaissance ; ils deviennent 
une aide précieuse pour un repérage historique. Ainsi, pour THALES, la nature 
n'est pas soumise au pouvoir arbitraire des divinités (qui ont d'autres préoccupations !),
mais elle obéit à des lois qu'il faut désormais découvrir. L'objectif de la connaissance
du ciel s'est déplaçé vers une approche "rationnelle" primitive. Toutefois les
représentations de l'univers restent fortement marquées par celles de la Mésopotamie
ancienne. Pour ANAXIMANDRE le ciel est sphérique avec une Terre en forme de cylindre aplatie
(galette). Doit-on à ce penseur l'introduction dans la Grèce antique du gnomon connu 
des mésopotamiens ? Certains auteurs lui ont attribué aussi la première fabrication
du cadran solaire, quand d'autres considèrent que son origine vient d'Egypte. 

Un des élèves d'ANAXIMANDRE (lui-même élève de THALES) est le célèbre PYTHAGORE. 
Même si on ne lui doit pas le théorème qui porte son nom, ce penseur marque durablement
la pensée de son temps. Il est à l'origine de la structuration de référentiels toujours
en vigueur, comme par exemple les sept notes de la gamme chromatique (en référence 
au sept "planètes" ?), ou le mot COSMOS désignant le monde "ordonné" dans lequel
nous sommes. Dans le cadre d'un système de pensée philosophique et politique 
(autour duquel se constitua une sodalité idéologique qui persista à bien après sa mort),
PYTHAGORE identifia le nombre comme principe premier.  L'harmonie de la nature était vue
comme une sorte de reflet de l'harmonie des nombres. Cette idée forte toujours persistante
est probablement une des racines de la pensée de PLATON. PYTHAGORE apparaît bien comme
"l'inventeur" de cet argumentation qui conduit à placer la Terre sphérique au centre
d'un ciel lui aussi sphérique (en raison toujours de ce fameux principe d'harmonie). 
Ainsi, à partir d'arguments dont l'abstraction peut surprendre près de six siècles 
avant notre ère, l'hypothèse hardie (et contraire aux perceptions immédiates) d'une
Terre sphérique est avancée. La hardiesse de cette hypothèse ne se limite pas à une
question de forme, mais aussi au fait qu'une Terre sphérique doit "tenir en l'air".

CCe courant de la pensée astronomique se poursuit au début de la période classique 
avec ANAXAGORE pour qui la Terre plate flotte dans l'air : même si les textes disponibles
disent peu de chose sur le sujet, on ne voit pas comment l'observation n'occuperait pas
une place réellement importante. ANAXAGORE semble bien avoir discerné la nature des éclipses,
et  explique que la Lune est éclairée par le Soleil. Avec METON un effort de rationalisation
du calendrier apparaît. C'est à PHYLOLAOS qu'on attribue la première affirmation que la Terre
n'est pas le centre du monde. Elle tourne en 24 heures dans le plan équatorial autour d'un
gigantesque feu central. Les autres astres tournent eux aussi, mais dans un autre plan
(l'écliptique). La Lune est toujours éclairée par le Soleil, lui-même réfléchissant la
lumière du feu central. Il précise le phénomène des éclipses, et redécouvre peut-être
la planète Saturne connue des mésopotamiens et de PYTHAGORE, mais qui avait semble-t-il
été oubliée. Cette représentation atteste à la fois d'une pensée abstraite élevée et
d'une réelle base de connaissances résultant d'un effort persistant d'observation et
probablement de mesures des angles (pour discerner la différence des plans de rotation).

Simultanément à ses approches, une formation de culmination de la pensée abstraite est 
atteinte avec PLATON. Cette pensée très brillante à un impact contradictoire sur le
s progrès futurs des connaissances astronomiques : d'une part, l'approfondissement de
la pensée abstraite dynamise la volonté d'accéder à l'essentiel, au-delà des apparences,
et de décrire quantitativement les phénomènes astronomiques ("les écrire en langage
mathématiques" comme dira plus tard GALILEE), mais d'autre part, le point de vue philosophique
"idéaliste" stérilise, la démarche observationnelle (de mesure), plongeant dans un mépris
durable (jusqu'à la Renaissance) l'effort d'observation des "apparences trompeuses". 
Pourtant, ce courant de pensée qui méprise la mesure (a-t-il totalement disparu de nos
jours ?) n'est devenu la pensée unique que beaucoup plus tard, entre le V<sup>ème</sup> 
et le VII <sup>ème</sup> siècle lorsque le dogme des religions monothéistes (principalement
chrétienne) imposa une vérité révélée. À l'époque de PLATON et durant plusieurs siècles,
cette idée fut combattue dans les discours et dans les actes. Cet affrontement entre
deux approches philosophiques n'est-il pas une des causes majeures des avancées conceptuelles,
notamment pour l'astronomie "grecque" des six siècles à venir? 

Toujours est-il qu'avec PLATON, la réalité devient réductible aux "idées" ou "formes". 
Les lois à découvrir sont de nature mathématique et toujours de l'ordre de l'abstrait
(obéissant d'ailleurs à des principes de perfection qui confinent au divin). Dans ce
cadre de pensée, la Terre demeure sphérique et placée au Centre d'un ciel lui aussi
sphérique. PLATON reprend l'idée mésopotamienne d'une partition de l'Univers avec un
monde sublunaire pour des hommes, puis un monde supralunaire pour les divinités,
habité par un nouveau constituant appelé "ether" pour monde invariant de tout éternité. 

Le monde sublunaire est celui de toutes les imperfections et de tous les changements. 
Il résulte de la composition des quatre éléments fondamentaux proposés quelques dizaines
d'années plus tôt par EMPEDOCLE : la Terre, l'Eau, l'Air et le Feu. Au-delà de la Lune
en rotation autour de la Terre tournent, sur des sphères concentriques, le Soleil, Vénus,
Mercure, Mars, Jupiter, Saturne puis enfin, la sphère céleste portant les étoiles. 
Ces rotations doivent respecter l'harmonie des nombres ; aussi PLATON propose-t-il 
à son "thésard" du moment, EUDOXE, d'établir les lois mathématiques décrivant ces
mouvements. Celui-ci construit un système de sphères homocentriques qui rend compte
du mouvement de Jupiter et de Saturne (correctement), de Mercure (moyennement) et
de Mars et Vénus( assez mal). Peut-être est-ce ces imperfections qui conduisent 
HERACLIDE a rejeter cette représentation, et à renouer avec l'approche "révolutionnaire"
de PHILOLAOS qui écartait la Terre du centre de l'Univers. Pour HERACLIDE l'Univers
est infini, et chaque étoile du ciel à ses propres planètes. Le ciel est fixe, c'est
la Terre qui tourne, avec autour d'elle d'abord la Lune, ensuite le Soleil avec autour
de lui les autres planètes. Ces idées étaient à cette époque débattues, comme d'autres
problèmes, sans aucune incidence religieuse ; simplement, il semble bien qu'elles
soient restées minoritaires ou en position de faiblesse par rapport aux idées dominantes.
il faut dire que l'ordre établit était alors du côté de PLATON et de son disciple,
contemporain d'HERACLIDE, le monument de la pensée occidentale pour plus deux millénaires
à venir : ARISTOTE. 

ARISTOTE, après avoir été l'élève de PLATON dans son "Académie" d'Athènes, part voyager
(nous dirions peut-être aujourd'hui en "post-doc" !). Il revient à Athènes, et fonde
le célèbre "Lycée" après avoir été précepteur du futur Alexandre Le Grand dans la cour
de Macédoine. C'est un érudit respecté et reconnu qui écrit de très nombreux ouvrages
qui s'imposeront comme la "Référence des Savoirs" durant tout le Moyen-Âge, (souvent
au travers de traductions édulcorées et qui gommeront les contradictions pour ne laisser
subsister que le terme conforme au dogme). ARISTITE reprend pour l'essentiel le point
de vue philosophique "idéaliste" de PLATON, mais il y rajoute des compléments contradictoires,
notamment une revalorisation de la mesure et une approche raisonnée déductive, ancêtre du
"raisonnement scientifique". Ainsi, pour la sphéricité de la Terre, ARISTOTE la fait découler
d'un principe d'harmonie (comme PLATON), mais aussitôt après s'empresse de l'argumenter : 
- elle résulte du fait que ses parties sont toutes également attirées par le centre de la Terre, 
- elle est attestée par la forme de son ombre sur la Lune lors des éclipses, 
- elle est suggérée par l'apparition d'étoiles nouvelles lors du déplacement Nord-Sud.

Sa représentation de l'Univers reprend pour l'essentiel celle de PLATON, complétée par son
modèle cinématique d'EUDOXE et de CALLIPE. L'Univers est borné, sphérique, centré sur une
Terre sphérique mais immobile. Les sphères géométriques d'EUDOXE prennent une existence
physique, avec de nouvelles sphères de couplage qui portent à 56 le nombre total de sphères
"dont les rotations uniformes sont entretenues par des intelligences". La partition de
l'Univers est reprise :
- l'espace sublunaire constitué dans l'ordre, de la Terre, de l'eau, l'air et le feu, 
- l'espace supralunaire, soit le ciel, domaine invariant des astres et occupé par le
cinquième élément, la quintessence ou éther.

C'est la représentation qui sera conservée jusqu'au XVII<sup>ème</sup> siècle. 
ARISTOTE insiste sur la différence de nature entre le monde sublinaire, domaine
de la génération et de la corruption, et le monde supra lunaire, domaine de l'éternité
et siège d'aucune altération. Cette représentation devenue dogme n'empêche t-elle pas
les érudits Européens du X<sup>ème</sup> siècle "de voir" l'explosion de la supernova
du Crabe, étoile nouvelle tellement brillante qu'elle se voyait en plein jour d'après
les témoignages des astronomes chinois ?

L'influence d'ARISTOTE fut capitale pour le moyen âge mais aussi dès son vivant, 
et elle ne fit que s'amplifier dans les dizaines d'années qui suivirent sa mort. 
La possession de ses œuvres originales devint en jeu culturel, de prestige et de 
politique ; ainsi les bibliothèques qui se développèrent au second siècle avant 
notre ère se disputèrent ses œuvres (voir CANFORA, 1988). Mais du vivant d'ARISTOTE, 
les idées avancées étaient objet de débat. Ainsi, à sa Terre centrale et immobile, 
à son Univers borné, son contemporains HERACLIDE DU PONT opposait une Terre en 
rotation dans un Univers infini avec un ciel immobile formé d'une multitude d'étoiles, 
chacune ayant ses propres planètes... Cette émulation n'a-t-elle pas apporté une 
contribution bénéfique au développement de méthodes rationnelles de recherche ? 
N'a-t-elle pas profité, notamment à ARISTOTE, pour pousser plus loin la nécessaire
argumentation, toujours recommencer dans son œuvre écrite ? Cette méthode d'exposition
d'une thèse par un raisonnement argumenté (qui se différencie progressivement dans
l'oeuvre d'ARISTOTE de la spéculation platonicienne) se retrouve dans les textes d'EPICURE.
Ce jeune homme de 19 ans à la mort d'ARISTOTE adopta le courant de pensée amorcé avec
ARISTIPPE de Cyrène, l'un des élèves de SOCRATE. Il fonde l'école du Jardin et donne
un essor considérable au courant philosophique du matérialisme. Pour EPICURE, la
sensation (la mesure) est au noeud de la connaissance. "Le monde a toujours été
et sera toujours". L'Univers infini est formé de vide et d'atomes. Il renoue avec
l'école atomiste de LEUCIPPE et de son élève DEMOCRITE (IV<sup>ème</sup> siècle -  
V<sup>ème</sup> siècle avant notre ère). Il énonce une théorie cosmogonique de
formation des astres par agrégats d'atomes lors de rencontres fortuites résultant
de tourbillon primordiaux. Il évoque la pluralité des mondes. À son argumentation
"physique" ("d'études de la nature") est associé à plaidoyer humaniste. Il sépare
l'approche astronomique de son double siamois l'astrologie. Il ironise et combat
la croyance astrologique qu'il traite de "puérilité". Il contraint l'argumentation
à l'épreuve des faits : 
- "car il ne faut pas conduire l'étude scientifique au moyen d'affirmations vides
et de principes arbitraires, mais suivre les phénomènes", 
- " ... quand on accepte une théorie pour en rejeter une autre qui s'harmonise
tout aussi bien avec le phénomène, Il est évident qu'on abandonne absolument 
le sentier de la recherche scientifique pour recourir au mythe..."

Comment ne pas être frappé par la modernité et la pertinence de telles phrases ? 
Avec le recul du XX<sup>ème</sup> siècle et la connaissance de tous les errements
qui ont suivi cette époque de l'Antiquité grecque, comment ne pas trouver dans 
les textes d'EPICURE des sujets forts pour la réflexion d'aujourd'hui ? 

Ainsi EPICURE, sans accomplir lui-même des mesures astronomiques a-t-il contribué
d'une manière décisive à la formation d'une méthodologie de recherche qui réhabilite
l'observation et l'expérimentation ("en suivant les phénomènes") contradictoirement
à la démarche spéculative prônée par PLATON. Cette composante qui ramène sans cesse
l'argumentation vers l'épreuve des faits constitue l'un des deux termes majeurs
du mouvement contradictoire de la pensée humaine, écartelée entre la nécessité de
confronter ses représentations à la réalité et à la volonté d'aller au-delà des
apparences par la nécessaire abstraction. Ce courant de pensée structuré notamment
par EPICURE a joué un rôle essentiel dans les dynamiques qui ont conduit aux grandes
avancées des connaissances. Remarquons que le co-fondateur avec EPICURE de cette
école de pensée, ARISTIPPE (ou peut-être l'un de ses descendants) a fondé l'école
de Cyrenaïque dont l'influence fut très importante et qui a, sans doute, marqué la
formation d'érudits aussi important que CALLIMAQUE et ERASTOSTHENE, irriguant ainsi
de ce courant de pensée le premier "centre de recherche" de l'époque, le fameux "musée"
associé à la bibliothèque d'Alexandrie (et dont la création remonte au règne de
PTOLEMEE SOTER premier roi d'Égypte de la dynastie des Lagides,  juste après la
venue dans ce pays dans ce pays d'Alexandre Le Grand vers 332 avant notre ère). 

ERATOSTHENE est devenue célèbre en mesurant le périmètre de la Terre avec une précision
tellement remarquable (de l'ordre du pourcent) que l'analyse de la procédure de mesure
n'a pas fini de faire l'objet de recherche (voir la fiche bibliographique à "ERATOSTHENE").
Mais cet érudit n'a pas été qu'un simple géomètre astronome, et sa vie bien remplie
le vit aussi tour à tour précepteur de l'héritier du trône d'Égypte et directeur
de la Grande Biibliothèque d'Alexandrie. Il concrétise le profil classique à ses
époques (et à d'autres...), d'érudits au spectre très large allant de l'astronomie
à la poésie en passant par la physique, les mathématiques et la géographie. Le résultat
célèbre d'ERATOSTHENE illustre tout le succès des progrès accomplis dans une démarche
"nouvelle" d'investigation fondée sur la mesure, aboutissement des débats d'idées 
des époques, respectivement archaïque, classique et hellénistique (début) de l'Antiquité
grecque. De fait, la réelle avancée ayant permis l'action ("mesure") était de l'ordre
conceptuel et non "technique" au sens étroit et restrictif de l'appareil (ou outil
matériel) utilisé ; en effet, ce dernier n'était autre qu'un gnomon, connu depuis
au moins un millénaire. L'avancée était 
1. d'imaginer la Terre sphérique avec un Soleil assez loin,
2. de savoir que les méridiens de Syène et d'Alexandrie étaient voisins,
3. de concevoir une démarche de recherche fondée sur la mesure et non la spéculation,

(ce qui voulait dire à la fois le respect des phénomènes au sens épicurien, et la 
capacité d'abstraction de construire par avance un modèle du projet accomplir avec
une estimation des moyens nécessaires à son accomplissement. 

Mais l'avancée conceptuelle seule ne suffisait pas, il fallait __en plus__ des moyens
économiques, c'est-à-dire à la fois une société ayant atteint un seuil de développement
( structuration et production de richesse) suffisant et une décision positive du pouvoir
politique de mettre à la disposition de "la recherche" les moyens nécessaires pour
permettre l'avancée ! Cet exemple montre toute la complexité des mécanismes qui 
"permettent" une avancée des connaissances ; avec une composante essentielle qui
établit, dans la vie concrète, la relation entre la recherche et la société. Omettre
dans l'analyse du mouvement des connaissances et, à fortiori, du développement de l'instrumentation
"lourde" qui l'accompagne cette composante socio-économique, c'est se priver des moyens
d'accéder à des dynamiques dominantes et se condamner à des spéculations portant sur
une réalité mutilée. 

D'une trentaine d'années l'ainé d'ERATOSTHENE, ARISTARQUE de Samos aurait été l'élève
de STRATON de lampsacque (à Athènes ou à Alexandrie ?), celui-là même qui prit la
direction du Lycée d'ARISTOTE (entre -288 et -284) à la mort de THEOPHRASTE, après
avoir été le précepteur de l’hériter royal d'Alexandrie.

ARISTARQUE combine la mesure d'angles Soleil / Lune lors du premier quartier avec
d'autres lors d'éclipses de Lune (voir le détail de la méthode dans Gapaillard, 1993).
Les mesures d'angle sont étonnamment imprécises (de 1 à 3 degrés d'arc). Il les
utilisent ensuite dans une description mathématique des phénomènes, pertinente,
même si la non-connaissance de la trigonométrie plane (découverte un siècle plus tard
par HIPPARQUE) la rend laborieuse. À partir de ces résultats, il est possible d'estimer
les distances du Soleil et de la Lune en fonction du rayon de la Terre. Les résultats
implicites d'ARISTARQUE forcent à l'admiration. Les ordres de grandeur sont atteints même
si des erreurs d'un facteur 2 à 3 résultent, pour l'essentiel de l'imprécision des mesures.
Comment expliquer des erreurs de 2 à 3 degrés d'arc quand on sait que des instruments 
rustiques avec la limitation de l'oeil humain permettent d'atteindre mieux que la dizaine
de minutes d'arc ?  Il est probable que l'explication est à chercher dans les concepts
qui sont à l'origine des procédures utilisées. Peut-être le statut ambigu de l'observation
des phénomènes, en contradiction (pour au moins une part...) avec le point de vue philosophique
idéaliste, hérité de la doctrine d'ARISTOTE et de PLATON y est-il pour quelque chose? Pourtant
, ARISTARQUE manifesta une indépendance d'esprit qui le conduisit à proposer, pour la première
fois, un système du monde héliocentrique. Pour lui, seule la Lune tourne autour de la Terre,
alors que toutes les planètes y compris la nôtre tourne autour du Soleil. Cette proposition
reçut plus d'hostilité que de sympathies. Le mouvement de la Terre était une idée difficile
à admettre. Elle s'opposait à la perception directe de l'expérience banale, et elle avait été
condamnée par celui qui devenait de plus en plus le maître à penser : ARISTOTE. De plus, la
proposition d'un monde héliocentrique était contraire au dogme religieux en vigueur à l'époque,
au point qu'un texte fut écrit par CLEANTE D'ASSOS, proposant de condamner ARISTOTE pour impiété
(déjà !). Il semble que seul l'astronome babylonien SELEUCOS ait manifesté un accord avec ce
monde héliocentrique.

Une quarantaine d'années après la mort d'ARISTARQUE naquit un autre monument de l'astronomie
antique : HIPPARQUE de Nicée. À son passif il faut noter son rejet catégorique du modèle
d'ARISTARQUE avec son attachement réaffirmé d'une Terre centrale et immobile. Mais de
nombreuses avancées sont à porter à son actif ; il fut l'inventeur de la trigonométrie
plane, le découvreur de la précession des équinoxes et l'auteur d'un premier grand catalogue
connu des étoiles classées par leur magnitude et leur position dans le ciel. Il place le
Soleil sur une orbite circulaire excentrée par rapport à la Terre et estime son déplacement
annuel (par rapport aux étoiles) à 36 secondes d'Arc (la valeur réelle pour son époque est
de l'ordre de 50). Il introduisit en Grèce la division du cercle en 360 degrés chacun divisé
en 60 minutes et chacune en 60 secondes d'arc. Ses résultats et son catalogue révèlent
de réels progrès dans la méthodologie des mesures réalisées. On connaît mal celle-ci,
de même que les instruments qu'HIPPARQUE avait (ou avait fait) utiliser, mais il semble
bien que les progrès ont permis d'accroître considérablement la précision (d'un ordre
de grandeur?). Lorsqu'HIPPARQUE meurt, ver 126 avant notre ère,  un transfert des savoirs
s'opère entre la civilisation hellénistique et la République romaine en plein essor.
Des personnes comme le grec et syrien POSIDONIOS d'Apamée y contribuèrent beaucoup. 
On doit cet érudit une nouvelle évaluation du périmètre de la Terre qui sera transmise
par les Arabes à l'Europe occidental du Moyen-Âge (alors que celles d'ERATOSTHENE fut
oubliée, avant d'être redécouverte vers le XIV<sup>ème</sup> siècle). Son enseignement
marqua de nombreux penseurs du monde greco-remain comme CICERON, VIRGILE et LUCRECE. 
Ce dernier est l'auteur du très célèbre "De natura rerum", oeuvre majeure et encyclopédique,
sorte d'exposé synthétique du courant de pensée matérialiste de l'Antiquité gréco-romaine. 
Elle est une pierre angulaire de ce courant qui va de l'atomisme grec de LEUCIPPE et DEMOCRITE
aux humanistes de la renaissance du XVI<sup>ème</sup> siècle et à nos jours, en passant
bien sûr par ARISTIPPE et EPICURE. 

L'approche exposée par LUCRECE, reprise d'EPICURE, complétée précisée, constitue
un des fondements majeurs des conceptions philosophiques implicites sur lesquelles
reposent les sciences contemporaines. Ce n'est pas le lieu ici d'entrer dans le détail
sur ce point ; la lecture du texte de LUCRECE "De la nature" est édifiante !

Avec l'époque de LUCRECE s'achève une période de plus de cinq siècles durant laquelle
le foisonnement des idées (notamment celles relatives à l'astronomie) a été florissant
et la production d'acquisitions nouvelles du savoir paraît continue. Près de deux siècles
vont s'écouler, pendant que s'affirme l'hégémonie de l'Empire romain, sans que des
événements originaux ou même remarquables concernant l'astronomie puisse être identifiés.
Certes, la grande bibliothèque d'Alexandrie continue d'être un Centre actif, mais il faut
attendre Claude PTOLEMEE, au second siècle de notre ère, pour percevoir dans la cité
d'Alexandrie une activité astronomique novatrice. L'explication d'une telle éclipse
de près de deux siècles précédant une autre, beaucoup plus longue de treize ou quatorze
siècles n'est pas sans poser de nombreux problèmes ! À ce jour, aucune argumentation
cohérente complète n'existe ; nul doute qu'il y a là de beaux thèmes de recherche
pour l'histoire des sciences...

Toujours est-il qu'au premier jour du second siècle de notre ère naquit à Alexandrie
Claude PTOLEMEE. Beaucoup plus tard et parfois jusqu’à un passé récent, il fut confondu
avec les Ptolémée, rois d'Égypte de la dynastie des Lagides (des trois derniers siècles
avant notre ère) et c'est pourquoi on le voit couronné en souverain sur beaucoup
d'illustrations. Claude PTOLEMEE réalisa une synthèse créatrice des savoirs astronomiques
de l'antiquité gréco-romaine. Son principal ouvrage, l'Almageste, traduit d'abord
du grec à l'arabe puis de l'arabe dans la langue latine, devint le principal recueil
des savoirs astronomiques de l'Europe occidentale du III<sup>ème</sup> au XVI<sup>ème</sup>
siècle. Il constitue un exposé des représentations de l'Univers, mais aussi une
compilation de mesures astronomiques, beaucoup ayant probablement été accomplies sous
la direction de PTOLEMEE. Il reprend le système géocentrique d'HIPPARQUE, qui résultait
lui-même de la tradition remontant à PLATON, complétée par EUDOXE et ARISTOTE et à 
laquelle APPOLONIUS avait apporté un rajout essentiel. Ce directeur de la bibliothèque
d'Alexandrie avait remplacé le système des sphère homocentrique d'EUDOXE en rotation
uniforme, par des mouvements circulaires uniformes comportant pour chaque astre deux
cercles.  Chaque astre (planètes, L'une et Soleil) est supposé tourner à une vitesse
constante sur un cercle nommé épicycle, dont le centre se déplace à vitesse angulaire
constante sur un autre cercle, coplanaire et centré sur la Terre, nommé déférent. 

Notons que ce modèle cinématique est strictement équivalent à un modèle héliocentrique
de rotation circulaire des planètes à vitesse angulaire constante, du point de vue de
la perception qu'il est possible d'avoir depuis la Terre (voir Gapaillard 1993, et fiche
biographique de PTOLMEMEE). C'est à dire qu'en toute première approximation, ce modèle
géocentrique rend compte aussi bien de la cinématique des planètes vues depuis la Terre,
qu'un modèle héliocentrique. En seconde approximation on sait bien, aujourd'hui, que
l'ellipticité des orbites va induire des différences avec de tels modèles équivalents. 
Ces différences ont été perçues par les mesures de l'époque. Aussi PTOLEMEE modifie t-il
le modèle simple d'APPOLONIUS en substituant à la rotation uniforme du centre de l'épicycle
une rotation sur le déférent (centrée sur la Terre) avec une vitesse angulaire constante
définie par un rayon vecteur dont l'origine n'est plus le centre du déférent mais un point
nommé équant, symétrique de la Terre par rapport au niveau au centre du déférent ; de plus,
les plans, respectivement de l'hémicycle et du déférent, deviennent distincts et séparés. 
Dans ce modèle, mieux ajusté aux observations disponibles, la Terre reste au centre de la
sphère céleste. Dans l'Amalgeste, elle conserve aussi une immobilité parfaite ("la Terre
ne peut avoir aucun mouvement"), mais cette position ne résulte en rien du modèle. 
Pourtant, durant tous les Moyen-Âge, pour combattre l'idée du mouvement de la Terre
on utilisera l'argument que le modèle de PTOLEMEE rend bien compte des observations ! ...

La fixité de la Terre ne résultait en rien du modèle, Celui-ci donnait une représentation
cinématique (rendant compte uniquement du mouvement sans aborder ses causes, la "dynamique")
tout à fait conforme aux observations, compte tenu de leur précision. Connaissant aujourd'hui
les valeurs des écarts entre la réalité et le modèle, il est possible d'estimer la
précision des mesures d'angle de PTOLEMEE : de l'ordre de la dizaine de minutes d'arc.
C'est à peu près ce que l'on peut faire de mieux avec des instruments à l'échelle 
humaine et une méthodologie minutieuse sans être trop contraignante (comme par exemple
sur les effets thermo-élastiques des instruments) ou trop rigoureuse sur les corrections
(comme par exemple la réfraction atmosphérique. Ce modèle, appuyé sur les observations, 
permet d'estimer les rayons des orbites des planètes (dans l'approximation circulaire, 
et normalisés par rapport à celui de la Terre) à mieux de 4% (voir fiche bibliographique
"PTOLEMEE"). Mais à ses estimations pertinentes (et admirables si l'on songe à l'époque), 
PTOLEMEE ajoute par une voix spéculative (non contrainte par les observations) une
évaluation des rayons des orbites exprimés en rayons terrestres : les valeurs sont
fausses de plusieurs ordres de grandeur ! On a là un exemple patent des errements
auxquels peuvent conduire des spéculations abstraites dès lorsqu'elles perdent l'adhérence
avec la réalité accessible par la mesure ! Il n'empêche que le modèle sophistiqué de
PTOLEMEE était tout à fait satisfaisant pour rendre compte des observations accessibles
à l'époque ;  aussi sa validation était-elle, alors, aussi pertinentes que celle d'un
modèle héliocentrique "aussi pertinente, c'est à dire n'est plus ni moins". Toutefois
il s'imposa comme le seul modèle acceptable (ce qui fut totalement abusif) jusqu'à la
remise en cause révolutionnaire de COPERNIC vers 1510. Notons que cette remise en cause
se fondait davantage sur une vision abstraite du système solaire que sur des résultats
observationnels nouveaux ; le modèle de COPERNIC ne rendait pas mieux compte des 
observations qui, pour l'essentiel, étaient les mêmes que celles compilées par PTOLEMEE...
Mais de PTOLEMEE à COPERNIC, plus de 13 siècles vont s'écouler. Une régression spectaculaire
va s'opérer. Les connaissances sont astronomie vont s'appauvrir au point de faire dire à 
Gaipallard (1993) qu'au Moyen-Âge chrétien" ... en ce qui concerne l'astronomie ... 
le niveau des connaissances a régressé à ce qu'il était vers l'époque de THALES". 

Pourtant, l'essor culturel du monde gréco-romain ne s'arrête pas brutalement à
l'époque de PTOLEMEE, même si un ralentissement est déjà nettement perceptible, 
Alexandrie demeurent un Centre actif, où cohabitent plusieurs langues (grec, égyptien,
latin) et plusieurs ethnies. Mais, avec l'emprise hégémonique de la religion monothéiste
chrétienne devenant la religion d'État, les tensions apparaissent. À la pluralité
d'opinions, de cultures, de philosophies, de religions, ce substitue peu à peu une
seule "Vérité". Forcément appauvrit, cette représentation dogmatisée du monde efface
les contradictions par un combat d'idées qui, très vite, se tranche par la force. 
Ainsi , au V<sup>ème</sup> siècle, à Alexandrie, HYPATIE (qui passe pour être la
"première femme astronome") est assassinée en 415 par une foule de chrétiens. 
Elle était la fille de THEON, dernier responsable connu de la bibliothèque et 
du musée. Peu après, à la même époque (vers la fin du IV<sup>ème</sup> siècle), 
l'empereur romain THEODOSE interdit l'usage de l'égyptien : les derniers hiéroglyphes
gravés, cette écriture va sombrer dans l'oubli forcé (au point de nécessiter les
efforts de recherche bien connus et les succès de CHAMPOLLION au XIX<sup>ème</sup> 
siècle, pour redécouvrir le sens de cette écriture et pouvoir la traduire à nouveau).
La fusion dans une autorité unifiée du pouvoir politique (de l'empereur romain) 
et d'une idéologie universaliste (la religion chrétienne) induit de fait une élimination
physique de tous les courants de pensée qui ne représentent pas une parfaite conformité
avec la "Vérité". Et qu'il est facile d'avoir un point de non-conformité dès lors
que des idées sont émises en dehors du cadre hiérarchique du pouvoir ! Aussi,
l'Empire romain s'engage-t-il dans une sclérose des savoirs avec des réductions
et des pertes irrémédiables. Le dogme devenu loi est implacable pour la pluralité
des savoirs et des approches, en un mot, pour la recherche de connaissances nouvelles.
SAINT AUGUSTIN vers l'an 400  traduit bien le point de vue dominant: " ... il
n'est pas nécessaire de sonder la nature des choses comme le faisaient les grecs
que l'on appelle que l'on appelle physico ... / ... aux chrétiens il suffit de
croire que la seule cause de toute chose, dans le ciel ou sur la Terre visible
ou invisible, est la bonté du Créateur ..." 

#### 5 - L'astronomie du moyen âge<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; et son instrumentation
<br>

Ainsi, vers le V<sup>ème</sup> siècle de notre ère s'ouvre une période sombre qui
durera plus de dix siècles, durant lesquels les débats d'idées (masquant presque
toujours des enjeux politiques et économiques) sont tranchés le plus souvent par
la force brutale. Certes, il faut nuancer. Ainsi, des domaines de la culture restent
marginalement concernés par la "Vérité révelée" : la poésie, la musique, l'art en
général, vont pouvoir poursuivre un développement, même si celui-ci est freiné,
bridé ou ralenti. D'autres répondent à un besoin économique direct : la métallurgie
par exemple, qui continue à progresser. Mais beaucoup, comme l'astronomie, se heurtent
de plein fouet au textes sacrés détenteurs de la vérité. La seule activité envisageable
sera bientôt l'interprétation des textes désignés comme la référence. D'autant que le
point de vue philosophique qui s'est imposé est celui (en plus très appauvri) du courant
idéalisme qui fait du Dieu éternel le créateur et l'ordonnateur de toute chose. 
Dans ces conditions, (outre le risque physique auquel on s'expose) à quoi peut
bien servir d'observer la nature, le ciel ou les astres ?Aussi les yeux vont-ils
se fermer, pour l'astronomie du monde chrétien, jusqu'à la Renaissance. Lorsqu'il
s'ouvriront, par exemple avec GALILEE, ce sera un conflit, avec un jugement et des
sanctions. Cette cécité sera telle que le phénomène astronomique spectaculaire de
l'explosion de la supernova du crabe vers l'an mil n'est mentionné par aucun texte
connu du monde chrétien. Il faut dire que les textes de référence pour l'astronomie
étaient ceux d'ARISTOTE (appauvris dans des traductions édulcorées) qui proclamaient
une sphère des fixes invariante de tout éternité !Ainsi, l'apport de la chrétienté
des siècles V à XVI est-il infime dans le secteur de l'astronomie. On a du mal à
mesurer ce que les pertes des savoirs de l'Antiquité gréco-romaine auraient pu être,
si, à côté de l'Europe chrétienne ne s'était pas développées de riches civilisations
islamiques. 

C'est en 476, lorsque ODOACRE dépose le jeune empereur romain d'Occident ROMULUS
AUGUSTULE et soumet Rome à l'empereur d'Orient (de BYZANCE) qu'on a coutume de voir
la fin de l'Empire Romain. Depuis déjà un siècle la division Rome /  Byzance s'est
amorcée. Des deux côtés des tensions politiques et religieuses s'accroissaient. 
L'unité de la religion chrétienne. n'était qu'apparente et de multiples luttes de
tendance s'opéraient : des particularismes locaux existaient en grand nombre dans
ce vaste empire qui se déchirait. Dans ce contexte troublé, dans l'Arabie du VII<sup>ème</sup>
siècle un prophète (parmi d'autres qui ont existé), Mahomet s'avère un efficace homme
politique et un redoutable chef militaire.

Dans la plus pure tradition des religions monothéistes, à côté du judaïsme et du
christianisme, il contribue à fonder l'islam, religion associée dès son origine à
l'organisation d'un nouvel état. Cet état s'étend très vite pour devenir un vaste
empire gouverné par les califes d'Arabie, puis par les Omeyyades, les Abbassides
et enfin les Ottomans. Fondé vers 610, cette religion-Etat étend son influence sur
le Proche-Orient et la partie orientale de la Méditerranée à une vitesse fulgurante.
Entre 632 et 642, l'Egypte par exemple est conquise. Progressant par l'Afrique du Nord,
les Arabes musulmans arrivent en Espagne et s'empare de Cordoue en 711. L'Emirat 
Omeyyades de Cordoue, dont l'apogée se situe au X<sup>ème</sup> siècle, jouera un rôle
essentiel dans la diffusion de la culture de l'Antiquité gréco-romaine vers l'Europe
chrétienne du Moyen-Âge. Dans un premier temps, l'Islam, comme le christianisme, 
affiche les ambitions totalitaires d'une idéologie à vocation universelle. Ainsi,
dans sa réponse au conquérant d'Alexandrie, AMROU, sur le sort à réserver au livre
de la bibliothèque, le calife OMAR écrit-il "si leur contenu est en accord avec celui
d'Allah, nous pouvons nous en passer puisque dans ce cas le livre d'Allah, le Coran,
est plus que suffisant. S'ils contiennent, au contraire, quelque chose de différent,
il n'est aucun besoin de les garder. Agit et détruit-les". On dit qu'il fallut six mois
pour brûler tous ces livres dans les thermes d'Alexandrie (Canfora, 1988). 

Mais après une période très courte d'intransigeance totalitaire, les rigueurs dogmatisme
du pouvoir politico-religieux s'éloignent des domaines de la culture comme l'art
et beaucoup de disciplines "scientifiques" dont notamment l'astronomie. En philosophie,
une source de renouveau va très vite être cherchée dans les textes grecs, avec une
ouverture d'esprit surprenante, si on compare à ce qui existe à la même période dans
l'Europe chrétienne. Le monde islamique jouera ainsi un double rôle en astronomie.
D'une part il préservera, puis diffusera par le biais de traduction arabe les œuvres
gréco-romaines. D'autre part il poursuivra le développement d'une astronomie, principalement
sur les plans de l'instrumentation et de l'observation. Deux branches d'expansion
vont se dessiner. L'une passe par l'Afrique Nord qui s'épanouit dans la péninsule ibérique.
L'autre relie le Proche-Orient à l'Inde et au sud de la Sibérie. C'est ainsi qu'à la fin 
du VII<sup>ème</sup> siècle, les Arabes conquièrent la Perse et découvrent l'astronomie
indienne qui avait depuis l'époque Hellénistique, un développement particulier; relativement
autonome ; elle reste mal connue et des recherches mériteraient d'être faites. C'est au
IX<sup>ème</sup> siècle que fleurissent les traductions arabes des textes grecs. 
(la première traduction de l'Almageste de PTOLEMEE remonte à 827) et que commencent
à être construits des observatoires astronomiques à Bagdad et à Damas. Des astronomes
arabes vont devenir célèbres en accomplissant des mesures dont la précision s'accroît
par rapport à PTOLEMEE. Au XX<sup>ème</sup> siècle, AZOPHI réalise un catalogue d'objets
célestes dans lequel figure la Grande Nébuleuse d'Andromède, et qui est à l'origine
de la plupart des noms actuels des étoiles. Quelques dizaines d'années plus tard ALHAZEN
conduit une critique de la précision des mesures de PTOLEMEE. Il conteste ses procédures
et découvre la réfraction atmosphérique. Il identifie aussi les incohérences de l'Almageste
et les Hypothèses Planétaires de PTOLEMEE. Il est surprenant de constater que l'astronomie
arabe du IX<sup>ème</sup> au XV<sup>ème</sup> siècle a apporté une contribution soutenue
au développement instrumental sans avoir été en mesure de faire franchir un pas qualitatif
au contenu des connaissances. Deux raisons peuvent être invoquées. La première est, qu'avec
PTOLEMEE, une sorte de perfection est atteinte dans la méthodologie, compte tenu des
limitations technologiques. Les nouveaux instruments astronomiques conçu et réalisé
n'apportent qu’une amélioration quantitative en précision (ou en commodité d'utilisation
propice, à un usage en voyage). Ainsi, avec les astrolabes portatifs du VII<sup>ème</sup>
/ VIII<sup>ème</sup> siècle devient-il possible de mesurer l'élévation d'un astre sur
l'horizon depuis plusieurs sites. Cette amélioration sert plus la géographie que
l'astronomie. C'est aussi l'époque où apparaissent les grands cadrans dont les dimensions
atteindront plusieurs mètres vers le XV<sup>ème</sup> et le XVI16<sup>ème</sup> siècle
en Perse ou à Samarkand, conquête islamique en 712, dévastée en 1220 par GENGIS KHAN,
redevenue islamisque ensuite, pour être au XV<sup>ème</sup> siècle la cité la plus
brillante de l'Asie centrale. Vers 1420, les moyens accordés par le prince OULOUGH-BEG
permettent la construction de vastes dispositifs en maçonnerie pour la mesure des angles
formés par les directions des astres. L'un d'eux mesuré environ 54 mètres de haut,
ce qui illustre bien que le gigantisme dans les instruments d'astronomie de date pas
du XX<sup>ème</sup> et XXI<sup>ème</sup> siècles ... Les constructions d'observatoires
en Asie se sont maintenus pendant de nombreuses siècles, notamment en Inde ou les
établissements de New Deli et de Jaipur (XVIII<sup>ème</sup> siècle) sont devenus
célèbres. En Chine aussi les vestiges sont là pour en témoigner, mais l'histoire 
de l'astronomie de ces pays reste encore mal connue. La deuxième raison qui a freiné
les acquisitions nouvelles de connaissances aux astronomiques, malgré le développement
de l'observation, a probablement sa source dans les limitations résultant de la 
méthodologie de mesure employé. Les altérations résultant de la réfraction atmosphérique
sont identifiées par ALHAZEN, mais des procédures rigoureuses de mesure ne sont pas
établies. En passant des cercles gradués de quelques décimètres des grecs du troisième
siècle avant notre ère, aux grands cadrans arabes du VIII<sup>ème</sup> siècle, 
la précision de la mesure peut passer de deux à trois dizaines à quelques minutes
d'arc. Mais la mesure du temps reste approximative et les efforts permettant de mettre
en œuvre une méthode de mesure très rigoureuse ne sont probablement pas justifiés 
par une conception rationnelle de l'observation pour pouvoir être accomplis.
Pourtant les observations n'ont cessé de se multiplier dans le monde islamique. 
Les progrès furent continuent mais seulement quantitatifs. Sans doute un verrou 
épistémologique empêcha t-il de fédérer les efforts pour franchir le saut qualitatif 
que franchirait au XVI<sup>ème</sup> siècle TYCHO-BRAHE. Simultanément à la construction
des observatoires de Bagdad et de Damas au IX<sup>ème</sup> siècle, la péninsule 
ibérique connaît aussi l'essor de l'astronomie. Dans le riche Emirat de Cordoue, 
l'astronomie bénéficie des moyens et d'une attention soutenue. Au XI<sup>ème</sup> 
siècle, alors que commencent à s'ériger les premières abbayes romanes des Pyrénées 
Catalanes, en Castille islamique, AZARQUIEL établit les "Tables de Tolède", vaste
compilation qui sert de base pour proposer une oscillation du plan de l'écliptique.
Les échanges culturels se multiplient sur le sol de la péninsule ibérique entre la
riche civilisation musulmane et les mentalités beaucoup plus frustres des royaumes
chrétiens de Castille et d'Aragon. C'est ainsi que, grâce à la coopération
des astronomes du monde islamique, se termine en 1272 la première production
astronomique importante de l'Europe chrétienne : les Tables Alphonsine, du nom de
souverain du royaume de Castille et de Léon : ALPHONSE X LE SAGE ; imprimées en 1483.
elles vont constituer une référence astronomique majeure pendant trois siècles. 
Le XIII<sup>ème</sup> siècle constitue une charnière pour l'Europe chrétienne qui
va découvrir, via les textes arabes, une astronomie fondée sur les connaissances
de l'antiquité gréco-romaine mais enrichie par des compilations d'observations nouvelles,
sensiblement améliorées en précision. Des érudits comme le catalan, Ramond LLULL 
vont devenir polyglottes et jouer un rôle éminent pour transférer les savoirs de 
l'arabe au latin et même directement dans les langues romanes (voir par exemple 
le "Llibre de Meravelles" de Ramon LLULL). Au courant principal passant par la 
péninsule ibérique, s'en ajoute bientôt un autre, traversant l'Italie, pour irriguer
petit à petit toute l'Europe chrétienne de la fin du Moyen-Âge. Aux textes écrits
dès le XII<sup>ème</sup> siècle qui donnaient une représentation naïve et christianisée
de l'astronomie (De imagine mundi d'Onorius d'AUTIN, Ymago mundi de Pierre D'AILLY,  
Le livre du Trésor de Brunetto LATINI, Sphaera mundi de Jean de SACRABOSCO) s'ajoutent
au XV<sup>ème</sup> siècle des traductions directes (mais souvent résumées) des textes
grecs originaux (par exemple, l'epitomé in Almageste de REGIOMONTANUS).

Aristote est devenu une référence, reconnue par l'Église catholique même si c'est
parfois par le biais d'une interprétation bien orientée. D'abord objet de vénération
incontestée (dans le monde chrétien), le XIV<sup>ème</sup> siècle connaît le début
d'une remise en cause, principalement de ses thèse portant sur la physique. BURIDAN
conteste la mécanique d'ARISTOTE et propose une théorie de "l'impétus" qui préfigure
le principe de conservation de la quantité de mouvement, et qui n'est pas sans rappeler
des propositions épicuriennes. ORESME, représentant le plus marquant de l'Humanisme
de la première Renaissance, propose que la Terre puisse être en mouvement avec une 
argumentation tout à fait pittoresque (voir fiche biographique). L'évocation d'un 
"principe d'économie" évoque le futur "principe de moindre action" fondant la mécanique. 
Mais la vraie révolution en astronomie, devenue célèbre, et celle de COPERNIC. 


#### 6 - Les révolutions de l'astronomie<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  à la Renaissance
<br>

Rédigé entre 1509 et 1512, le "Commentariolus" de COPERNIC propose un monde héliocentrique.
Cette vision déjà soutenue par ARISTARQUE dix-sept siècles plus tôt, allait mettre près
de deux siècles pour s'imposer à l'issue d'un combat contre la vision officielle de
l'Église Catholique. Il est intéressant de noter que l'argument pour répondre à
l'objection de la parallaxe des étoiles (qui consiste à multiplier par 65 la distance,
supposée par PTOLEMEE, à la sphère des étoiles) avait aussi été exprimé par ARISTARQUE.
Ce qui va choquer le plus le dogme dominant sera la mise en mouvement de la Terre et sa
sortie du centre du monde. Cette rupture sera d'autant moins appréciée par l'autorité
qu'elle n'obéit à aucune nécessité observationnelle. Nous avons déjà évoqué avant
qu'une description géocentrique aménagée (PTOLEMEE) rendait aussi bien compte des
observations que la représentation héliocentrique (ARISTARQUE et COPERNIC) si nous
nous en tenons au simple niveau cinématique, ce que fait COPERNIC. De fait, sa proposition
apparaît plus comme une révolution conceptuelle relative à la place des hommes dans
l'Univers que comme un modèle plus élaboré rendant mieux compte des observations. 
Le "Commentariolus" et le "De revolutionibus orbium coelestium" constituent davantage
une brisure du paradigme officiel assignant, aux hommes, une place particulière dans
l'Univers, conforme au dogme religieux, qu'une nouvelle théorie scientifique destinée
à rendre mieux compte des mesures. C'est probablement cela l'essentiel qui motiva 
la mise à l'index, par l'Église catholique, de ces ouvrages. Il est probable que
COPERNIC en vint à ce point de vue par une réflexion qui le conduisit à trouver 
"plus naturel", "moins artificiel", un système héliocentrique que l'ancien géocentrique,
compte tenu du système idéologique (implicite?) qui était le sien, en rupture par
rapport à l'idéologie dominante de la religion catholique. Il faut dire que dans
l'Europe Centrale, la Réforme était en train de s'imposer, même si COPERNIC fut lui-même
Chanoine de Cracovie : mais son immense érudition, ses nombreux voyages lui avaient
assurément permis d'acquérir une hauteur de vue et une indépendance de pensée susceptibles
de le libérer des pesanteur du dogme ... Un autre aspect moins connu des activités
de COPERNIC fut sa participation, permanente, tout au long de sa vie, à des observations.
Notons que sa conviction était que la dizaine de minutes d'arc constitue une limite ultime
pour la précision des mesures angulaires. Il est probable qu'en 1543 rien de mieux n'avait
pu être fait. Mais COPERNIC exprime là une préoccupation nouvelle d'importance : la
précision des mesures qui, jusque là, n'avait pas été identifiée clairement comme un
élément devenant devant retenir l'attention (même si, implicitement, il avait fait
l'objet de soins probables ...). C'est pourtant par ce chemin qu'allait passer le
triomphe de la perception héliocentrique du monde !

Trois ans après la mort de COPERNIC naissait TYCHO-BRAHE. Il est bien connu que durant
sa jeunesse il fut fasciné par les capacités de prédiction de l'astronomie, et il fut
témoin de plusieurs événements célestes. Dès 1569-1570, il se fait construire des instruments
d'observation (grands quarts de cercle, notamment) et un grand globe. Il développe des projets
de "grands instruments", notamment le sextant de 1,8 mètres et un cadran de rayon supérieur
à 6 mètres. Avec ces instruments, il pousse la précision des mesures au point ultime accessible
sans l'intermédiaire de dispositif optique (en complément de l'oeil), c'est à dire environ
la minute d'arc ( voir ci-après, au paragraphe "un exemple de système instrumental : l'oeil humain").
Pour atteindre cette précision, il faut rendre toutes les autres causes d'erreur négligeables
devant la limite de résolution angulaire de l’œil (dont la valeur est justement de l'ordre
de la minute d'arc). Pour se faire, on sait que TYCHO-BRAHE dressa des tables de correction
atmosphérique. On sait moins le détail de ses procédures de mesure, mais il est sûr qu'elles
devaient être extrêmement rigoureuses, et probablement utiliser des séries statistiques. 
Elles devaient aussi avoir recours régulièrement à des ré-étalonnages. Il est sûr, enfin,
que les précisions atteintes manifestent une maîtrise technologique des constituants de ces
instruments pour contrôler les déformations et limiter les effets thermo-élastiques. Peut-être
la maîtrise du bois, constituant essentiel, s'apparentait-elle à la connaissance empirique 
qui préside encore aujourd'hui à la construction des instruments de musique. Il y a là 
encore de belles recherches qui restent à faire ... Toujours est-il que TYCHO-BRAHE 
accomplit un saut qualitatif dans la précision des mesures, et donc dans la description
quantitative des mouvements des astres. Une des conditions nécessaires qu'il ne faut
pas mettre, était qu'il disposait d'un soutien financier du pouvoir politique. On sait
que TYCHO-BRAHE s'était vu accordé l'île de Ven (ou Hven) par le roi du Danemark, créant
ainsi un grand observatoire qu'il dirigea pendant 13 ans. 

À partir de ces mesures, il conteste le modèle héliocentrique et propose un troisième
modèle du monde rappelant celui d'HERACLIDE. On lui doit aussi la publication d'observations
qui rendent compte, directement, de faits contradictoires avec le dogme aristotélicien 
d'un monde supralunaire invariant. La première observation concerne l'explosion de la
supernova dans Cassiopée (qui porte aujourd'hui son nom), le 11 novembre 1572. La seconde
se rapporte au passage d'une comète du 13 novembre 1577 au 26 janvier 1578. Contradictoirement
à ARISTOTE, il localise la comète dans l'espace supralunaire, ce qui constitue un nouveau
coup porté au dogme officiel de l'immutabilité du ciel. Après la mort du souverain qu'il
l'avait soutenu dans ses efforts observationnels, le nouveau pouvoir politique réduit
son soutien financier pour faire fonctionner l'Observatoire de Hven, et TYCHO-BRAHE
se rend à l'invitation de l'empereur d'Allemagne. Il y rencontrera KEPLER à qui il lègue
la somme considérable de résultats observationnels amassés durant sa vie d'astronome-observateur.
Né en Allemagne un quart de siècle après TYCHO-BRAHE,  KEPLER devient professeur de mathématiques.
Il acquiert une notoriété en publiant à calendrier "divinatoire". Il s'intéresse très vite
à l'astronomie qu'il aborde avec un point de philosophique dans le droit fil des conceptions
platoniciennes où l'esthétique et la magie des nombres tiennent une place essentielle pour
tenter d'expliquer les phénomènes. Il publie un nouveau modèle du monde de type héliocentrique.
Dans une correspondance retrouvée,  TYCHO-BRAHE critique l'arbitraire des spéculations
mathématiques et insiste sur la nécessité de fonder les représentations sur des mesures
soigneuses. Inversement, KEPLER pousse TYCHO à publier ses données observationnelles : 
"il faut s'efforcer de mendier auprès de lui ses observations pour les publier sans
altérations et toutes". En possession de la "banque de données" de TYCHO,  KEPLER
s'engage dans l'étude du mouvement de Mars. En 1609 il publie "Astronomia nova". 
Dans cette publication exemplaire d'honnêteté intellectuelle, il relate le détail
de ses recherches, de ses cheminements, de ses succès et de ses échecs. Une citation
peut être retenue " ... en TYCHO-BRAHE un observateur d'une extrême habilité, 
dont les travaux font apparaître l'erreur de 8 minutes d'arc que PTOLEMEE fait dans
son calcul ; il est légitime que nous reconnaissions et que nous utilisions avec
gratitude cette faveur de Dieu. Nous devons donc travailler à découvrir enfin la
forme véritable des mouvements célestes, en abandonnant toutes ces hypothèses
fictives". Nous avons là le texte d'une proposition de programme de recherche
tout à fait moderne et convaincante ! Il fait dire à SIMON (1979) : " ... parce 
qu'aujourd'hui elles ne peuvent plus être négligées, ce sont ces seuls 8 minutes
d'arc qui ouvrirent la voie à la complète réforme de l'astronomie". Ainsi, la démarche
de KEPLER sera-t-elle doublement novatrice. D'une part il prend appui, en toute clarté,
sur un écart entre la prévision d'un modèle et la réalité révélée par la mesure, pour
invalider le modèle initial et fixer, par avance, des conditions de validité du nouveau
modèle à construire ; ce faisant, il reste au niveau d'une description cinématique
du mouvement des astres. Mais la seconde volonté novatrice affichée très vite par
KEPLER est de dépasser le niveau simplement cinématique pour accéder à la dynamique
des phénomènes, c'est à dire pour identifier les relations entre les mouvements
et leurs causes. Cette volonté est affichée dans le titre de la publication qui
résultera de ce "programme de recherche" : "Astronomie nouvelle par les causes
ou la physique céleste" qui énoncera les deux premières lois de KEPLER, la loi
des aires et l'ellipticité des orbites. D'abord limiter à Mars, ces lois sont
généralisées et complétées par la troisième loi (de l'invariance du rapport du cube
de la valeur du grand axe et du carré de la valeur de la période sidérale). Même
s'il n'avait pas "expliqué" les causes du mouvement (il a utilisé la mécanique
aristotélicienne, fausse !) et donc s'il n'avait pas atteint son objectif de
représenter la dynamique, KEPLER avait franchi un saut qualitatif dans la description
cinématique, créant ainsi les conditions de nouvelles recherches pour accéder à une
représentation pertinente des relations entre les mouvements des planètes et leur cause. 

C'est NEWTON qui apportera la description dynamique vers 1666. Il aurait imaginé d'étendre
l'attraction gravitationnelle observée localement par la chute d'une pomme sur la Terre,
jusqu’à la Lune, puis en l'appliquant au Soleil jusqu'aux planètes (dans le cadre du modèle
héliocentrique complété par les lois de KEPLER). Dans ses "Principes mathématiques de philosophie
naturelle", publiés en 1687, il fonde une nouvelle mécanique à partir de trois postulats :
1. le principe d'inertie,
2. la proportionnalité de l'accélération avec la force d'attraction gravitationnelle pour les planètes,
3. L'égalité de l'action et de la réaction.

C'est cette mécanique qui allait être triompher jusqu'à la fin du XIX<sup>ème</sup> siècle,
et  étayer l'illusion d'une identité de cette description mécanique à la réalité. 
Pour construire sa mécanique, NEWTON a beaucoup bénéficié des avancées contestataires de GALILEE,
mort  l'année de sa naissance. Par exemple, le second postulat de NEWTON dérive directement
des résultats de mesures de GALILEE, ceux-ci l'ayant conduit à formuler sa loi de la chute
des corps, (voir la "troisième journée" de son "Discours concernant deux sciences nouvelles",
et RIVAL (1996)). GALILEE a apporté une contribution essentielle non seulement à l'astronomie,
mais au fondement de la physique moderne, et plus généralement à "l'approche scientifique". 
Pourtant il lui en coûta de s'opposer au dogme officiel du pouvoir en place institutionnalisé
par l'Église Catholique. Dès 1614 il fait l'objet de menaces précises. Après la publication
de son "Dialogue sur les deux grands systèmes du monde" (1632), il est traîné devant la
tribunaux, emprisonné, contraint à se rétracter et condamné à la réclusion à vie dans sa
demeure des environs de Florence. C'est une époque où la force physique continue d'être
le recouru ultime pour imposer la pensée de la réligion totalitaire, là où elle a conservé
le pouvoir. Il y a à peine plus de trois dizaines d'années que les pensées non conformes
au dogme officiel avaient conduit Giordano BRUNO au bûcher (en 1600 à Rome) ; simplement
parce qu'il avait défendu des idées non officielles et notamment pour avoir plaidé une
mobilité de la Terre en utilisant des arguments physiques en cohérence avec une conception
galiléenne du mouvement. Il n'en fallait pas plus pour être suspecté d'hérétisme ! Le 20
janvier 1600, le pape CLEMENT VIII ordonna le jugement ; jugé hérétique, il est condamné
par le tribunal de l'Inquisition à être brûlé vif, après avoir été torturé. Ses ouvrages
sont mis à l'index et brûlés sur la place Saint-Pierre. Lorsque le 8 février 1600, la sentence
lui est lue publiquement, il aurait déclaré : "vous éprouvez sans doute plus de crainte à rendre
cette sentence que moi à l'accepter" (voir l'ouvrage "L'infini, l'Univers et les mondes", 
Giordano BRUNO, Berg international éditeurs, 1987). Le 17 février 1600, Giordano BRUNO 
fut brûlé vif sur le Campo dei Fiori à Rome. Cette érudit qui avait enseigné la physique
à Toulouse et à Paris, avait plaidé une Terre mobile dans un Univers infini, contenant une
pluralité des mondes ... Ce contexte permet de juger le courage de GALILEE, qui continua
le combat d'idées. 

La formulation de la loi de la chute des corps par GALILEE fait l'objet de discussion
toujours ouvertes (voir notamment FEYERABEND, 1979) mais il est clair qu'en transgressant
les apparences entachées d'erreur, GALILEE discerne l'essentiel, la "loi physique" ; 
ce qui est devenu la règle des sciences d'aujourd'hui ... Mais le mérite de GALILEE
ne s'arrête pas là. Il va renouer avec l'ambition "astrophysique" du courant d'idées
reliant les matérialismes gréco-romains (LEUCIPPE, DEMOCRITE, EPICURE, LUCRECE, ... etc ...)
qui se proposent de connaître la nature des astres (leur "physique") sans faire aucune
présupposition. Cette idée est contraire à la doctrine de PLATON et ARISTOTE qui postule
une nature idéale "divinement parfaite" pour le monde supralumaire, différente de celle
de notre monde sublunaire. Pour y parvenir, GALILEE va contribuer à réaliser un nouvel
instrument qui va permettre de franchir un saut qualitatif dans les performances de l'observation. 

Vers le début de 1609, GALILEE s'intéresse à un appareil optique connu depuis peu : 
la lunette. Il conçoit et réalise un instrument performant qu'il utilise au mois
d'août dans une démonstration devenue célèbre (voire fiche bibliographique). C'est
fin novembre / début décembre qu'il tourne sa lunette vers le ciel pour faire, en deux mois,
cinq découvertes majeures :
1. l'observation de la lune révèle une surface rugueuse, contredisant la perfection idéale du dogme aristotéticien. 
2. il résout la Voie Lactée,
3. il découvre les quatre gros satellites de Jupiter, "étoile errantes" qui portent un coup de plus au dogme de
l'invariance de l'espace supralunaire,
4. il découvre les phases de Vénus, apportant ainsi un résultat observationnel qui s'accorde
mieux avec le modèle copernicien qu'avec un modèle géocentrique
5. enfin il met en évidence des tâches solaires. 

Sa publication "Sidereius Nuncius" sorti en 1610 reçoit un accueil réservé. La remise en
cause des conceptions aristotéliciennes résultant de l'usage d'un nouvel instrument
n'est pas sans induire des suspicions ... 

Après les cinq découvertes succédant à la mise en oeuvre de la lunette, nous avons
là un cas d'école d'un des processus conduisant à l'acquisition de connaissances
nouvelles. Ces dernières résultent directement d'un saut qualitatif des performances
observationnelles, elles-mêmes induites par une transition qualitative de la technologie
utilisée. Beaucoup d'autres cas de type de processus existent, notamment dans l'époque
contemporaine, avec l'usage de l'instrumentation astronomique spatiale. Nous y reviendrons,
mais n'oublions pas que ce type de processus n'est pas le seul existant ... 


#### 7 - L'essor de l'astronomie<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;et son instrumentation au temps moderne
<br>

Il est frappant de constater que dans le domaine du développement instrumental, 
NEWTON, encore lui, prolonge l'oeuvre engagée par GALILEE. Même si l'idée n'est
pas exclusivement de NEWTON (voir fils bibliographique), c'est quand même lui qui
réalise le premier télescope, certes de dimensions modestes mais appelé un glorieux
avenir. Aujourd'hui, la supériorité incontestable du télescope est sa possibilité
de disposer d'une pupille de grande dimension (plusieurs mètres) permettant ainsi
d'accroître à la fois la surface de collection du rayonnement incident, et la résolution
angulaire limitée par la diffraction. La lunette, elle, connait une limitation technologique
drastique : un diamètre de l'ordre du mètre limité par la nécessaire homogénéité du 
verre de l'objectif. Mais l'intention à l'époque de NEWTON était de résoudre le problème
des aberrations chromatiques dont les optiques par transmission (à lentilles) avaient
du mal à s'accommoder. Pendant des dizaines d'années une sorte de compétition aura lieu ... 
Notons enfin que le télescope de NEWTON utilisait un miroir entièrement métallique, dont
l'usage, vite abandonné au bénéfice de miroirs en verre métallisé pour une utilisation
en lumière visible, est revenu à l'ordre du jour aujourd'hui pour l'infrarouge et le
submillimétrique (y compris pour des diamètres de l'ordre du mètre et plus). 

Le développement instrumental pour l'astronomie devient à cette époque de plus en plus
couplé à celui de la physique, tout comme pour le développement conceptuel. D'ailleurs,
l'expérimentation va agir directement pour trouver la réponse à des questions millénaires
concernant à la fois la physique et l'astronomie. Deux exemples peuvent être évoqués. 
Le premier concerne le vieux débat qui opposait dans l'antiquité grecque les matérialistes
(dont EPICURE) et l'école aristotélicienne : le vide existe-t-il ? Oui disait les premiers,
non avait répondu ARISTOTE.  Les expériences de TORRICELLI et de PASCAL tranchèrent 
le débat par une mise en évidence expérimentale directe (voir par exemple RIVAL, 1996).
Le second concerne la valeur de la vitesse de la lumière. EMPEDOCLE, EPICURE, LUCRECE
attribuaient une valeur finie à la vitesse de la lumière. ARISTOTE notait qu'"une telle
opinion est contraire à la fois la raison et aux faits observés". GALILEE reprend l'idée
des matérialistes grecs, mais ne trouve pas d'argument décisif. Jean-Dominique CASSINI
remarque des irrégularités dans le mouvement d'un satellite de Jupiter, et il envisage
une interprétation par une valeur finie de la vitesse de la lumière ; mais il ne peut
pas mettre en évidence cet effet sur les trois autres satellites connus. ROMER reprend
l'étude et il finit par convaincre après avoir fait une prévision qui se révèle exacte
; toutefois la méconnaissance des distances ne permet pas d'estimer la valeur de la vitesse
de la lumière, mais seulement sa finitude. En 1728, BRADLEY mesure "l'aberration de la
lumière" en cherchant la en cherchant la valeur de la parallaxe annuelle de l'étoile 
Gamma du Dragon ; la seule interprétation raisonnable et d'attribuer une valeur finie
à la vitesse de la lumière pour expliquer les valeurs de BRADLEY. C'est FIZEAU qui obtiendra
en 1849 la valeur de 315000 km/s à l'aide d'une expérience utilisant une roue dentée
(hacheur de faisceau) dont on ajuste la vitesse de rotation pour "éteindre" le faisceau
réfléchi sur un miroir situé à une dizaine de kilomètres. Plus tard, en 1881, MICHELSON
et MORLEY utiliseront une expérience interférométrique pour préciser cette valeur et
montrer son invariance, pas essentiel vers la relativité d'EINSTEIN.

Mais il faut revenir au début du XVII<sup>ème</sup> siècle et évoquer deux figures
de l'astronomie de la physique : DESCARTES et HUYGENS. DESCARTE développe une pensée
philosophique unificatrice fondant la démarche d'acquisition des connaissances
sur la rationalité. On connaît sa contribution à l'optique (lois de l'optique géométrique)
et aux mathématiques. Sa pensée finement nuancée a fortement contribué à construire
les fondements des méthodes scientifiques. En astronomie, il propose un Univers infini,
avec une matière fluide en tourbillons localisés qui entraînent dans leur mouvement
les astres ; de plus, ces tourbillons expliquent l'attraction centrale, par exemple
de la Terre sur les corps à sa surface. Cette "physique tourbillonnaire" est reprise
par HUYGENS. Cet astronome va contribuer, en plus de ses travaux en physique et en
mathématiques, au développement instrumental. Il invente des lentilles achromatiques
avec lesquelles il confectionne un nouveau type d'oculaire qui lui permet de découvrir :   
1. l'anneau de Saturne, 
2. la rotation de Mars,
3. et la grande nébuleuse d'orion en 1656.

Il établit la théorie du pendule, et utilise ce dispositif expérimental pour réguler
les horloges mécaniques, parvenant ainsi à des précisions nettement meilleures que 
la seconde pour la mesure du temps. 

C'est près d'un siècle plus tard que MESSIER dresse son fameux catalogue de 103 objets
célestes étendus. À cette époque, les télescopes s’étaient perfectionnés et avaient
accru leur diamètre. HERSCHELL fabrique un puissant instrument d'un mètre vingt de 
diamètre pour le miroir primaire. La résolution angulaire, limitée par la diffraction,
est ainsi portée à près d'un dixième de seconde d'arc en lumière visible ; désormais
c'est la turbulence atmosphérique qui va limiter la résolution angulaire avec des
instruments qui est deviendront de moins en moins aberrants (au sens de l'optique géométrique).
Avec ces instruments aux performances qualitativement accrues, il découvre :
1. Uranus et deux de ces satellites, 
2. deux satellites de Saturne,
3. et des étoiles doubles. 

Il étudie ces systèmes binaires et observe des nébuleuses. Il fonde la photométrie
stellaire en lumière visible. Il fait la première détection de flux de rayonnement 
infrarouge en provenance du Soleil. Nous avons là encore un exemple d'avancées résultant
d'un saut qualitatif des performances d'instrumentales

À terminer. 

#### 8 - La place de l'instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  dans l'histoire de l'astronomie
<br>

L'histoire de l'astronomie, depuis la Mésopotamie ancienne jusqu’à nos jours, 
en passant par l'Antiquité grecque et la Renaissance en Europe occidentale, 
montre que l'instrumentation est un maillon __toujours présent__ dans la chaîne
du processus d'acquisition de connaissances nouvelles. Toujours, la mise en oeuvre
de l'instrumentation a été une condition nécessaire, mais pas suffisante. 

La mise en oeuvre d'une instrumentation dans le processus de la mesure astronomique
(ou observation) mobilise toujours 3 sous-systèmes principaux :
1. un objet inerte (ou un ensemble d'objets) qu'on appellera instrument ou outil,
2. une méthode d'utilisation (ou généralement un ensemble de méthodes),
3. des ressources (moyens économiques, budgétaires, humains, en matériels périphériques ou logistiques.

La mise en oeuvre d'une instrumentation astronomique s'est exercée de multiples manières ;
deux idéaux-types extrêmes peuvent être identifiés. 

Le premier est l'__idéal-type de validation__. L'exemple célèbre est celui de la 
découverte de Neptune. Un modèle très élaboré rendant compte des perturbations de
la trajectoire d'Uranus fait une prévision : l'existence d'une nouvelle planète, 
Neptune, et sa localisation. L'auteur du modèle, LE VERRIER, propose à son collègue
GALLE de mettre en oeuvre une instrumentation pour __valider__ le modèle. Grâce à 
l'existence de l'outil adapté (son télescope), de sa connaissance de la méthode 
appropriée, et parce que des moyens existent pour faire fonctionner son observatoire,
GALLE "découvre" Neptune le 23 septembre 1846.
Cet exemple concerne la mise en oeuvre d'une instrumentation déjà existante. Dans 
d'autres cas, il faut la concevoir et la réaliser. Un autre exemple beaucoup plus
modeste et plus récent peut être cité. En 1985, un modèle propose l'existence, en
abondance, de molécules policycliques aromatiques dans la matière interstellaire ;
si tel est le cas, un motif spectral à 3,3 micromètres de longueur d'onde doit exister
dans le flux diffus rayonné par le disque de la Galaxie. Comme l'atmosphère est très
absorbante et perturbante, il est nécessaire de réaliser cette mesure depuis l'espace. 
Un instrumentation embarquable en ballon stratosphérique est conçue et réalisée pour
atteindre cet objectif. Le 30 juillet 1987, un vol transméditerranéen permettait de
détecter pour la première fois ce motif spectral à 3,3 micromètres depuis une altitude
de 37 km. Dans cet exemple, grâce aux ressources accordées par le CNRS et le CNES, une
instrumentation a pu être conçue, réalisée et mise en oeuvre. La méthode identifiée
s'est avérée adaptée, et la procédure de validation s'est accomplie ; Ce fut le programme
AROME. Cette __idéal-type de validation__ est celui qui est presque toujours implicite
dans l'idéologie contemporaine des astronomes. Ainsi, la réalisation d'une instrumentation
suppose l'acquisition de moyens attribués au terme d'un processus de sélection très dur. 
Pour gagner cette sélection, le projet choisi, (parmi d'autres qui sont abandonnés)
doit prouver que sa réalisation va permettre de valider un modèle d'objet ou de phénomènes
cosmiques dont l'enjeu de connaissance est jugé prioritaire. Cette idéologie contemporaine
est cohérente avec celle qui domine dans notre société très attachée à garantir une rentabilité
maximum des investissements. Elle satisfait, aussi, l'esprit rigoureux des scientifiques
qui aiment concevoir la démarche de recherche comme un processus ordonné, avançant pas
à pas sur une ligne continue. Pourtant, l'histoire de l'astronomie jette un doute épais
sur la continuité de la ligne de recherche et sur la capacité de "programmer" l'avancée
des connaissances ! Existe-t-il, __aujourd'hui__, une possibilité de programmation là où
__hier__, l'histoire montre que ce fut impossible la plupart du temps ? Cette question
mériterait une réponse approfondie. Bordons nous ici à la poser, sans tenter d'y répondre ... 

L'idéal type de validation est minoritaire dans l'histoire de l'astronomie. Celui qui domine
nettement est l'__idéal-type d'exploration__. Lorsque des mésopotamiens au grecs, les
astronomes observent l'ombre du Soleil et de la Lune produite par un bâton vertical
(le gnomon), ils cherchent d'abord à connaître la course de ces astres. Peut-être, ensuite
, le gnomon fut-il aussi utilisé dans une démarche de validation. Mais dans un premier temps,
les outils simples des astronomes (gnomon, polos, grand-cercles, quadrants ...) furent
utilisés dans une démarche d'exploration. Lorsque TYCHO BRAHE amasse des mesures du mouvement
de Mars, mettant en oeuvre des outils et des méthodes permettant de franchir un seau qualitatif
en précision (d'un facteur de l'ordre 10), il ne le fait pas pour __valider__ le modèle que KEPLER
construira après sa mort ! C'est pourtant ces mesures "d'exploration" qui vont permettre à KEPLER
d'identifier un écart de 8 minutes d'arc entre la réalité et le modèle de PTOLEMEE, créant 
ainsi les conditions de sa découverte des fameuses lois et de renforcer le crédit de la 
représentation copernicienne d'un monde héliocentrique !

L'__idéal-type d'exploration__ est le plus représentatif en histoire de l'astronomie ; 
il soulève le problème de la relation de cette science avec la technologie. D'une manière
générale, la mise en oeuvre d'une instrumentation astronomique correspondant à l'idéal-type
d'exploration, résulte de l'accession à une nouvelle technologie. Le mot "technologie" est
accommodé à beaucoup de sauces ... / ... On l'entend ici au sens défini dans le lexique.
C'est l'accès à une technologie, nouvelle pour l'astronomie, qui a apporté une contribution
à l'origine des grandes avancées des connaissances. Ainsi, lorsque GALILEE tourne sa lunette
vers le ciel, il lui suffit de deux mois pour faire cinq grandes découvertes ( la surface
"rugueuse" de la Lune, la résolution des étoiles de la Voie Lactée, les satellites de Jupiter
, les phases de la Lune, les tâches solaires ), contribuant à bouleversement de notre représentation de l'Univers. 
C'est avec son nouveau télescope d'un mètre vingt de diamètre qu'HERSCHELL instaure une
nouvelle ère de l'astronomie, découvre deux satellites d'Uranus, deux satellites de Saturne,
recense près de 250 nébuleuses, confirme le mouvement du système solaire dans la Galaxie,
découvre les systèmes binaires d'étoiles, fonde la photométrie dans le domaine visible, 
et découvre le rayonnement infrarouge en provenance du Soleil !
Ce! idéal-type d'exploration correspond généralement à une démarche d'investigation 
indépendante de celle de l'idéal-type de validation (qui résulte d'une intention précise
bien identifiée). Parfois, elle est franchement contradictoire.  Ainsi, lorsqu’en 1850 / 1851
l'autodidacte Léon FOUCAULT observe dans sa cave un pendule constitué d'une sphère
de laiton de 5 kg pendu à un fil d'acier de 2 mètres, il le fait en contradiction
avec les prévisions des modèles officiels. Son expérience, reproduite dans la grande
salle méridienne de l'Observatoire de Paris,  puis au Panthéon en Mars 1851, sera
pourtant qualifiée (en 1904) par Camille FLAMMARION de "la plus magnifique leçon
d'astronomie populaire qui ait jamais été donnée au grand public. ( ... ). La Démonstration
pratique, évidente, majestueuse, du mouvement de rotation de notre globe ... ". Pourtant
lorsqu'ARAGON lut, le 3 février 1851, le rapport de l'expérience devant l'Académie des sciences,
un fumé de scandale s'éleva. Non seulement toutes l'école mathématique, notamment française,
très compétente dans les savants calculs de la mécanique n'avaient pas prévu la rotation
apparente du plan d'oscillation du pendule, mais encore certains, parmi les plus éminents
comme POISSON (dans le journal de l'École Polytechnique) avaient écrit que l'effet n'existait
pas (LAPLACE avait fait de même) ;  cette affirmation résultait d'une activité de type "spéculative",
c'est à dire d'une théorie ou d'un modèle sans susciter le besoin d'une validation par l'expérience. 
Or, deux siècles plus tôt, l'élève de GALILEE, Vicenzo VIVIANI avait dès 1660-1661 noté : "Nous 
observons que tous les pendules à un seul fil dévient du plan vertical initial, et toujours dans 
le même sens". Il ne fait pas de doute que si l'expérience de FOUCAULT avait nécessité de gros
moyens, les notabilités scientifiques de son temps n'auraient pas sélectionné son projet !  
Notons aussi que la puissance spéculative peut écraser un résultat d'expérience antérieur
de deux siècles ! Cela est-il pensable aujourd'hui ? Laissons à chacun le soin de répondre,
à sa convenance, à cette question. Le pendule de FOUCAULT fut à l'origine d'une polémique
qui se développa autour de son interprétation, mais qui concerna aussi la permanence de la
tension qui existe entre la théorie (représentation abstraite) et la mesure (interaction 
d'un individu ou d'un collectif humain avec la réalité, objet d'étude et de la représentation
abstraite). Ainsi, le mécanicien Louis POINSON écrivait peu après, à propos de l'interprétation
du pendule de FOUCAULT (voir Gapaillard, 1993, p247) :
" Sitôt qu'un auteur ingénieux a su parvenir à quelques vérités nouvelles, n'est-il 
pas à crainte que le calculateur le plus stérile ne s'empresse d'aller vite la rechercher
dans ces formules, comme pour la découvrir une seconde fois, à sa manière, qu'il dit
être la bonne et la véritable ; de telle sorte qu'on ne s'en croit plus redevable qu'à
son analyse, et que l'auteur lui-même, quelquefois peu exercé ou même étranger à ce
langage et à ces symboles, sous lequels on lui dérobe des idées, ose à peine réclamer
ce qui lui appartient, et se retire presque confus, comme s'il avait mal inventé ce 
qu'il a si bien découvert ?"

En fait, entre l'idéal-type de validation et celui d'exploration, il existe tout
un continuum dans lequel se rangent les mises en oeuvre d'instrumentation astronomique.
Un exemple peut-être mentionné : la mesure du périmètre terrestre d'ERATOSTHENE. 
S'il existe une intention préalable, ce n'est pas celle de valider un "modèle sphérique". 
L'objectif de la mesure est la connaissance de la valeur du périmètre. De ce fait, 
cette mesure révèle davantage de l'idéal-type d'exploration que de celui de validation. 
Gardons-nous de réduire l'idéal-type de validation à une démarche intentionnelle, 
et réciproquement. Dans tous les cas (les deux idéaux-types et tout le continuum) 
__il existe une intention__, d'autant plus forte et argumentée qu'il faudra convaincre
pour acquérir des ressources. L'action de conviction nécessaire à la réalisation
d'une mesure, échappe parfois (souvent ?) à la sphère de la seule logique scientifique.
Une condition nécessaire de réalisation est de nature socio-économique et presque
toujours aussi socio-politique, avec une adhérence très forte à un système idéologique
, plus ou moins partagé entre une communauté scientifique (ou une de ces parties) et
un pouvoir politique dispensateur de ressources. Ce tissu de relations entre l'activité
scientifique et la société est un déterminant essentiel de la dynamique d'acquisition
des connaissances, d'autant plus vrai en astronomie que des moyens lourds sont mobilisés
pour accomplir les mesures nouvelles ... Ainsi, la place que la société attribue à la 
recherche en astronomie, traduite pour une part essentiel par les ressources affectées, 
est-elle un des déterminants principaux de l'avancée des connaissances ...

#### 9 - La płace de l'instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  dans l'astronomie d'aujourd'hui
<br>

Le statut de l'instrumentation en astronomie est un débat ; il constitue un enjeu philosophique
étroitement corrélé au point de vue épistémologique que chaque astronome porte sur sa
discipline consciemment ou inconsciemment. Implicitement, plusieurs représentations de
la démarche de recherche en astronomie cohabitent, parfois au sein même de la conscience
d'un seul individu !

Réduite au statut "technique", l'instrumentation est considérée trop souvent comme
une activité __extérieure__ et __annexe__ à l'astronomie. Au mieux, elle constitue un
__outil__ utilisé par quelques astronomes (devenu dans cette représentation des utilisateurs)
pour accroître le contenu d'une __banque de données__ dont les informations objectives
existent en soi. Ainsi, à l'occasion de chaque observation aux mesures, les informations
acquises avec cet outil vont-elles s'ajouter à un stock préexistant et constituer un 
__référentiel objectif__ de la connaissance astronomique dans le statut n'est pas trè
s éloigné  d'une sorte de __vérité révélée__ une fois pour toute. Cette représentation,
presque toujours implicite, est sous-jacente au discours qui sortent l'instrumentation 
de __l'intérieur__ même de l'astronomie. Pourtant le choix est incontournable. Ou bien
l'astronomie fonde sa démarche sur des informations lui venant de __l'extérieur__ , 
ou bien une composante __intérieure__ à cette discipline scientifique s'identifie à 
l'acquisition des informations pour s'inscrire dans une démarche de découverte (idéal-type
d'exploration) et/ou de confrontation de la prévision de ses modèles à la sanction de la réalité
(idéal type de validation). Le premier terme de l'alternative ne laisse pas beaucoup de place
à autre chose que l'acceptation d'une __vérité révélée__ qui est peu compatible avec une démarche
"__scientifique__". Le deuxième terme inclut de fait la conception, la réalisation et la mise
en oeuvre de l'instrumentation à l'intérieur d'une démarche globale d'acquisition et de 
validation des connaissances relatives à l'Univers, c'est à dire à l'intérieur de la discipline
scientifique désignée par le mot "astronomie". 
L'histoire de l'astronomie est là pour illustrer ce débat. Chaque fois que la pratique
de cette discipline a rejeté l'instrumentation (vers l'extérieur), ce fut la dérive vers
la spéculation et la perte d'adhérence avec la réalité que l'on se proposait de mieux
connaître. À l'inverse, une corrélation étroite existe entre les étapes clés du mouvement
des idées (relatif à l'univers) et l'essor de nouvelles générations d'instruments
astronomiques.

De fait, tout au long de son histoire, l'astronomie a vu vivre et se développer 
simultanément diverses approches, parfois distinctes et divergentes, voire contradictoires,
et d'autres fois étroitement mêlées, convergentes ou complémentaires. De la contemplation
passive à une démarche de modélisation/prédiction/mesure/validation critique, la connaissance
de l'Univers est toujours passée par la mise en oeuvre d'une "__instrumentation__". Réduite
à l'oeil dans les phases les plus primitives, l'instrumentation s'est élargie dès l'antiquité
la plus ancienne à divers __outils__ " instruments" conçus et réalisés dans un but bien précis.
S'il est vrai que ce but se réduisait parfois au seul désir d'exploration (dans l'espérance
de découvertes inattendues), d'autres fois, ce but était destiné à confronter une prévision
à une observation originale, autrement dit, à une nouvelle mesure. Et c'est bien là une
vocation singulière de l'instrumentation en astronomie : permettre de confronter une prédiction
(résultant d'une théorie ou d'un modèle) à la réalité, perçue par l'intermédiaire d'une mesure
et, ce faisant, ouvrir la voie à des découvertes inattendues. Cette confrontation est une
condition nécessaire pour légitimer le statut de "__Science__" aujourd'hui attribué (avec raison)
à l'astronomie. Sans cette étape clé de confrontation à la réalité, l'astronomie n'échapperait
pas à la condition d'activité intellectuelle spéculative laissant le champ ouvert à toutes les fantaisies ...
L'objet d'étude de l'astronomie est l'Univers.  À l'exception des régions du Système Solaire 
(fraction infime et peut représentative), les mesures in situ sont inenvisageables. La simulation
à l'échelle 1 des phénomènes étudiés et leur reproductibilité en laboratoire sont presque toujours
exclues. Aussi, le "moment de l'expérimentation" dans la démarche scientifique de l'astronomie 
a-t-il un contenu singulier et relativement réduit (par rapport à d'autres disciplines scientifiques).
Il se limite (presque toujours) à la collecte et à la mesure de rayonnement émis, à l'origine, 
par les objets étudiés de l'Univers. Ces mesures de "rayonnement" (électromagnétiques, de particules
chargées, de neutrinos, d'ondes gravitationnelles) se font par l'intermédiaire de l'instrumentation.
La conception, la réalisation et la mise en oeuvre de l'instrumentation et donc un moment essentiel
dans le processus d'acquisition des connaissances relatives à l'Univers. Identifier son statut à 
celui d'une "technique" ou d'"un ensemble de techniques" est une réduction qui lui enlève l'essentiel
de son sens. L'instrumentation n'est pas un intermédiaire objectif qui fabrique des informations
objectives dont la validation va de soi. Ceux qui pratiquent le développement instrumental et
l'exploitation des mesures savent bien l'ampleur des tâches à accomplir pour acquérir de 
l'information "intéressante" à partir des signaux enregistrés. Deux obstacles doivent être 
successivement franchis :
1. premièrement, l'acquisition d'une connaissance précise et approfondie de l'instrument utilisé 
(qui souvent va limiter la précision des mesures),
2. deuxièmement les procédures de traitement du signal, mise en oeuvre presque toujours 
au prix d'approximations et de choix (qu'il vaut mieux expliciter et soumettre 
à la critique). 

Nous sommes loin d'une procédure "objective" (ou neutre) de production 
de connaissances identifiables à une vérité révélée ! La conception, la réalisation
et l'utilisation de l'instrumentation constituent des moments essentiels de la __démarche scientifique__ 
permettant d'acquérir des connaissances nouvelles en astronomie. Le terme d'instrumentation 
désigne donc, à la fois, des appareils mais aussi des outils de mesures et des méthodes ; 
il se réfère au moment crucial et décisif de la rencontre entre la réalité de l'Univers et
la représentation que nous nous en faisons. Ainsi que d'autres activités de la recherche,
la conception, l'utilisation de l'instrumentation, de même que l'analyse des informations
associées, doivent constituer l'enjeu d'un débat et d'une critique sans concession de la communauté
des astronomes. Sans cette activité essentielle, il ne peut pas y avoir de validation d'un progrès
des connaissances. 

Aujourd'hui, parmi la très grande diversité des situations singulières, le fonctionnement de
l'astronomie moderne peut se décrire comme l'accomplissement et la mise en relation de boucles
élémentaires qui peuvent se schématiser, en premier approximation, de la manière suivante. 
Partant d'un écart entre une prédiction et une mesure, une analyse va se développer en essayant
d'intégrer les acquisitions les plus récentes de l'astronomie, mais aussi de disciplines adjacentes
(principalement physique, chimie et mathématiques). À cette phase de travail succédera l'établissement
d'un nouveau modèle destiné à donner une représentation la plus complète et la plus satisfaisante
possible de l'objet ou du phénomène (processus) étudié. Souvent ce nouveau modèle existera au
terme d'un processus de recherche, dont une étape peut être l'expérimentation de laboratoire,
la simulation où l'emprunt pur et simple de résultats nouveaux de discipline adjacentes 
(physiques, chimie, mathématiques). La validation de ce nouveau modèle est impose une prédiction, 
si possible quantitative (valeur d'une grandeur physique par exemple). C'est là qu'intervient 
la phase cruciale de la confrontation de cette représentation avec la réalité. Cette phase est
celle de l'instrumentation. Tester la prédiction suppose la mise en oeuvre d'une instrumentation
adaptée ou "système complexe de mesure". Parfois cette action impose de concevoir et de développer
une nouvelle instrumentation ; cette activité est désormais désignée par le terme de "projet instrumental". 
L'utilisation de l'instrumentation permettra __in fine__ de tester la validité de la prédiction, et par
la suite du nouveau modèle. Un désaccord caractérisé entraînera le rejet du modèle, un accord lui
attribuera une validité reconnue. Mais en général, la réalité s'avère plus complexe qu'on aurait
pu le croire au premier abord ; si le nouveau modèle s'accorde mieux que les anciens avec la 
mesure nouvelle, il ne suffit tout de même pas à tout expliquer. Et de ce nouvel écart surgira
un nouveau cycle de l'activité de recherche en astronomie. Bien sûr, ce schéma décrivant des 
activités relatives à un processus en ligne ("unidimensionnel") ne donne qu'une image simplifiée
de la pratique de recherche en astronomie (pluridimensionnelle, parfois hésitante avec des retours
en arrière, fédérant souvent plusieurs besoins de validation dans un seul "projet instrumental" ... 
etc ... Mais ce schéma peut être retenu pour décrire la maille élémentaire du réseau tissé par les
pratiques modernes de la recherche astronomique, à condition d'avoir de ce schéma une conception
ouverte et large, et non étroitement mécaniste. Même dans le cheminement linéaire de l'idéal-type
de validation, la réalité s'avère, __presque toujours__, plus complexe qu'on ne l'avait prévu 
au départ. Ainsi des caractéristiques de l'idéal-type d'exploration accompagneront toujours 
une démarche d'investigation mettant en oeuvre une instrumentation. Une illustration peut être
mentionnée avec tous les grands projets de relevés systématiques du ciel ("les manips de type Survey").
Ces projets sont défendus, au départ, sur la base d'un idéal-type de validation. Cette pratique 
réductrice est une réponse aux besoins d'une procédure de sélection fortement déterminée par
une idéologie dominante, par un cadre socio-institutionnel et par des pesanteurs politico-économiques.
À l'arrivée, les résultats à qui, au terme de la démarche de validation pèsent souvent peu devant 
ceux produits par une pratique (de fait) d'exploration. Cette réalité accompagne presque toujours 
les projets concrétisant un saut qualitatif dans les performances instrumentales (ou de mesure). 

En bref, l'instrumentation constitue donc un moment crucial dans le processus d'acquisition
des connaissances en astronomie. Son existence et sa place à l'intérieur des pratiques de
recherche des astronomes fonde le statut de discipline scientifique attribué désormais, 
avec raison, à l'astronomie.

Guy Serra